/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.help.CommandUsageGenerator;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.cli.CliCommandUsageGenerator;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;

public class HelpOption<C> {
    @Inject
    private GlobalMetadata<C> globalMetadata;
    @Inject
    private CommandGroupMetadata groupMetadata;
    @Inject
    private CommandMetadata commandMetadata;
    @Option(name={"-h", "--help"}, description="Display help information")
    public Boolean help = false;
    private boolean shown = false;

    public boolean showHelpIfRequested() {
        return this.showHelpIfRequested(new CliCommandUsageGenerator());
    }

    public boolean showHelpIfRequested(CommandUsageGenerator generator) {
        if (this.help.booleanValue() && !this.shown) {
            this.showHelp(generator);
            this.shown = true;
        }
        return this.help;
    }

    public void showHelp() {
        this.showHelp(new CliCommandUsageGenerator());
    }

    public void showHelp(CommandUsageGenerator generator) {
        if (generator == null) {
            throw new NullPointerException("Usage generator cannot be null");
        }
        try {
            generator.usage(this.globalMetadata != null ? this.globalMetadata.getName() : null, this.groupMetadata != null ? HelpOption.toGroupNames(this.groupMetadata) : null, this.commandMetadata.getName(), this.commandMetadata);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating usage documentation", e);
        }
    }

    private static String[] toGroupNames(CommandGroupMetadata group) {
        ArrayList<CommandGroupMetadata> groupPath = new ArrayList<CommandGroupMetadata>();
        groupPath.add(group);
        while (group.getParent() != null) {
            group = group.getParent();
            groupPath.add(0, group);
        }
        return UsageHelper.toGroupNames(groupPath);
    }
}

