/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.annotations.restrictions;

import java.util.Iterator;

public enum PortType {
    OS_ALLOCATED(0, 0),
    SYSTEM(1, 1023),
    USER(1024, 49151),
    DYNAMIC(49152, 65535),
    ANY(0, 65535);

    private final int min;
    private final int max;

    private PortType(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMinimumPort() {
        return this.min;
    }

    public int getMaximumPort() {
        return this.max;
    }

    public boolean inRange(int port) {
        return port >= this.min && port <= this.max;
    }

    public String toString() {
        if (this.min != this.max) {
            return String.format("%d-%d", this.min, this.max);
        }
        return Integer.toString(this.min);
    }

    public static String toRangesString(Iterable<PortType> portTypes) {
        StringBuilder builder = new StringBuilder();
        Iterator<PortType> iter = portTypes.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

