/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.builder;

import com.github.rvesse.airline.CommandFactory;
import com.github.rvesse.airline.DefaultCommandFactory;
import com.github.rvesse.airline.DefaultTypeConverter;
import com.github.rvesse.airline.TypeConverter;
import com.github.rvesse.airline.builder.AbstractBuilder;
import com.github.rvesse.airline.builder.AliasBuilder;
import com.github.rvesse.airline.model.AliasMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.aliases.AliasArgumentsParser;
import com.github.rvesse.airline.parser.options.ClassicGetOptParser;
import com.github.rvesse.airline.parser.options.LongGetOptParser;
import com.github.rvesse.airline.parser.options.OptionParser;
import com.github.rvesse.airline.parser.options.StandardOptionParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ParserBuilder<C>
extends AbstractBuilder<ParserMetadata<C>> {
    protected TypeConverter typeConverter = new DefaultTypeConverter();
    protected final Map<String, AliasBuilder<C>> aliases = new HashMap<String, AliasBuilder<C>>();
    protected CommandFactory<C> commandFactory = new DefaultCommandFactory<C>();
    protected boolean allowAbbreviatedCommands;
    protected boolean allowAbbreviatedOptions;
    protected boolean aliasesOverrideBuiltIns;
    protected boolean aliasesMayChain;
    protected final List<OptionParser<C>> optionParsers = new ArrayList<OptionParser<C>>();
    protected String argsSeparator;

    public static <T> ParserMetadata<T> defaultConfiguration() {
        return new ParserBuilder().build();
    }

    public ParserBuilder<C> withCommandFactory(CommandFactory<C> commandFactory) {
        this.commandFactory = commandFactory;
        return this;
    }

    public ParserBuilder<C> withDefaultCommandFactory() {
        this.commandFactory = null;
        return this;
    }

    public AliasBuilder<C> withAlias(String name) {
        this.checkNotBlank(name, "Alias name");
        if (this.aliases.containsKey(name)) {
            return this.aliases.get(name);
        }
        AliasBuilder alias = new AliasBuilder(name);
        this.aliases.put(name, alias);
        return alias;
    }

    public AliasBuilder<C> getAlias(String name) {
        this.checkNotBlank(name, "Alias name");
        if (!this.aliases.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Alias %s has not been declared", name));
        }
        return this.aliases.get(name);
    }

    public ParserBuilder<C> withUserAliases(String programName) throws IOException {
        return this.withUserAliases(programName + ".config", null, System.getProperty("user.home") + "/." + programName + "/");
    }

    public ParserBuilder<C> withUserAliases(String programName, String searchLocation) throws IOException {
        return this.withUserAliases(programName + ".config", null, searchLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParserBuilder<C> withUserAliases(String filename, String prefix, String ... searchLocations) throws IOException {
        Properties properties = new Properties();
        File homeDir = null;
        if (!StringUtils.isEmpty((CharSequence)System.getProperty("user.home"))) {
            homeDir = new File(System.getProperty("user.home"));
        }
        HashSet<String> loaded = new HashSet<String>();
        for (int i = searchLocations.length - 1; i >= 0; --i) {
            String loc = searchLocations[i];
            if (StringUtils.isBlank((CharSequence)loc)) continue;
            if (loc.startsWith("~" + File.separator)) {
                if (homeDir == null) continue;
                loc = homeDir.getAbsolutePath() + loc.substring(homeDir.getAbsolutePath().endsWith(File.separator) ? 2 : 1);
            }
            if (loaded.contains(loc)) continue;
            File f = new File(loc);
            if (!(f = new File(f, filename)).exists() || !f.isFile() || !f.canRead()) continue;
            try (FileInputStream input = new FileInputStream(f);){
                properties.load(input);
                continue;
            }
            finally {
                loaded.add(loc);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            ArrayList<Object> keysToRemove = new ArrayList<Object>();
            for (Object key : properties.keySet()) {
                if (key.toString().startsWith(prefix)) continue;
                keysToRemove.add(key);
            }
            for (Object key : keysToRemove) {
                properties.remove(key);
            }
        }
        for (Object key : properties.keySet()) {
            String name = key.toString();
            if (!StringUtils.isBlank((CharSequence)prefix)) {
                name = name.substring(prefix.length());
            }
            AliasBuilder<C> alias = this.withAlias(name);
            String value = properties.getProperty(key.toString());
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            List<String> args = AliasArgumentsParser.parse(value);
            alias.withArguments(args.toArray(new String[args.size()]));
        }
        return this;
    }

    public ParserBuilder<C> withAliasesOverridingBuiltIns() {
        this.aliasesOverrideBuiltIns = true;
        return this;
    }

    public ParserBuilder<C> withAliasesChaining() {
        this.aliasesMayChain = true;
        return this;
    }

    public ParserBuilder<C> withCommandAbbreviation() {
        this.allowAbbreviatedCommands = true;
        return this;
    }

    public ParserBuilder<C> withOptionAbbreviation() {
        this.allowAbbreviatedOptions = true;
        return this;
    }

    public ParserBuilder<C> withTypeConverter(TypeConverter converter) {
        this.typeConverter = converter;
        return this;
    }

    public ParserBuilder<C> withDefaultTypeConverter() {
        this.typeConverter = null;
        return this;
    }

    public ParserBuilder<C> withOptionParser(OptionParser<C> optionParser) {
        if (optionParser != null) {
            this.optionParsers.add(optionParser);
        }
        return this;
    }

    public ParserBuilder<C> withOptionParsers(OptionParser<C> ... optionParsers) {
        if (optionParsers != null) {
            for (OptionParser<C> parser : optionParsers) {
                if (parser == null) continue;
                this.optionParsers.add(parser);
            }
        }
        return this;
    }

    public ParserBuilder<C> withOnlyDefaultOptionParsers() {
        this.optionParsers.clear();
        return this.withDefaultOptionParsers();
    }

    public ParserBuilder<C> withDefaultOptionParsers() {
        return this.withOptionParsers(new StandardOptionParser(), new LongGetOptParser(), new ClassicGetOptParser());
    }

    public ParserBuilder<C> withArgumentsSeparator(String separator) {
        this.argsSeparator = separator;
        return this;
    }

    @Override
    public ParserMetadata<C> build() {
        ArrayList<AliasMetadata> aliasData;
        if (this.optionParsers.size() == 0) {
            this.withDefaultOptionParsers();
        }
        if (this.aliases != null) {
            aliasData = new ArrayList<AliasMetadata>();
            for (AliasBuilder<C> aliasBuilder : this.aliases.values()) {
                aliasData.add(aliasBuilder.build());
            }
        } else {
            aliasData = new ArrayList();
        }
        return new ParserMetadata<C>(this.commandFactory, this.optionParsers, this.typeConverter, this.allowAbbreviatedCommands, this.allowAbbreviatedOptions, aliasData, this.aliasesOverrideBuiltIns, this.aliasesMayChain, this.argsSeparator);
    }
}

