/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help;

import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.cli.CliCommandGroupUsageGenerator;
import com.github.rvesse.airline.help.cli.CliCommandUsageGenerator;
import com.github.rvesse.airline.help.cli.CliGlobalUsageGenerator;
import com.github.rvesse.airline.help.cli.CliGlobalUsageSummaryGenerator;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.utils.predicates.parser.AbbreviatedCommandFinder;
import com.github.rvesse.airline.utils.predicates.parser.AbbreviatedGroupFinder;
import com.github.rvesse.airline.utils.predicates.parser.CommandFinder;
import com.github.rvesse.airline.utils.predicates.parser.GroupFinder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;

@Command(name="help", description="Display help information")
public class Help<T>
implements Runnable,
Callable<Void> {
    @Inject
    public GlobalMetadata<T> global;
    @Arguments
    public List<String> command = new ArrayList<String>();
    @Option(name={"--include-hidden"}, description="When set the help output will include hidden commands and options", hidden=true)
    public boolean includeHidden = false;

    @Override
    public void run() {
        try {
            Help.help(this.global, this.command, this.includeHidden);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating usage documentation", e);
        }
    }

    @Override
    public Void call() {
        this.run();
        return null;
    }

    public static void help(CommandMetadata command) throws IOException {
        Help.help(command, System.out);
    }

    public static void help(CommandMetadata command, boolean includeHidden) throws IOException {
        Help.help(command, includeHidden, (OutputStream)System.out);
    }

    public static void help(CommandMetadata command, OutputStream out) throws IOException {
        Help.help(command, false, out);
    }

    public static void help(CommandMetadata command, boolean includeHidden, OutputStream out) throws IOException {
        new CliCommandUsageGenerator(includeHidden).usage(null, null, command.getName(), command, out);
    }

    public static <T> void help(GlobalMetadata<T> global, List<String> commandNames) throws IOException {
        Help.help(global, commandNames, false, System.out);
    }

    public static <T> void help(GlobalMetadata<T> global, List<String> commandNames, boolean includeHidden) throws IOException {
        Help.help(global, commandNames, includeHidden, System.out);
    }

    public static <T> void help(GlobalMetadata<T> global, List<String> commandNames, OutputStream out) throws IOException {
        Help.help(global, commandNames, false, out);
    }

    public static <T> void help(GlobalMetadata<T> global, List<String> commandNames, boolean includeHidden, OutputStream out) throws IOException {
        CommandMetadata command;
        Object findCommandPredicate;
        if (commandNames.isEmpty()) {
            new CliGlobalUsageSummaryGenerator<T>(includeHidden).usage(global, out);
            return;
        }
        String name = commandNames.get(0);
        if (name.equals(global.getName())) {
            new CliGlobalUsageGenerator<T>(includeHidden).usage(global, out);
            return;
        }
        Object findGroupPredicate = global.getParserConfiguration().allowsAbbreviatedCommands() ? new AbbreviatedGroupFinder(name, (Collection<CommandGroupMetadata>)global.getCommandGroups()) : new GroupFinder(name);
        CommandGroupMetadata group = (CommandGroupMetadata)CollectionUtils.find(global.getCommandGroups(), (Predicate)findGroupPredicate);
        if (group != null) {
            ArrayList<CommandGroupMetadata> groupPath = new ArrayList<CommandGroupMetadata>();
            groupPath.add(group);
            if (commandNames.size() == 1) {
                new CliCommandGroupUsageGenerator<T>(includeHidden).usage(global, groupPath.toArray(new CommandGroupMetadata[0]), out);
                return;
            }
            int i = 1;
            String commandOrSubGroupName = commandNames.get(i);
            while (group.getSubGroups().size() > 0 && i < commandNames.size()) {
                commandOrSubGroupName = commandNames.get(i);
                findGroupPredicate = global.getParserConfiguration().allowsAbbreviatedCommands() ? new AbbreviatedGroupFinder(commandOrSubGroupName, (Collection<CommandGroupMetadata>)group.getSubGroups()) : new GroupFinder(commandOrSubGroupName);
                CommandGroupMetadata subGroup = (CommandGroupMetadata)CollectionUtils.find(group.getSubGroups(), (Predicate)findGroupPredicate);
                if (subGroup == null) break;
                groupPath.add(subGroup);
                group = subGroup;
                if (++i != commandNames.size()) continue;
                new CliCommandGroupUsageGenerator<T>(includeHidden).usage(global, groupPath.toArray(new CommandGroupMetadata[0]), out);
                return;
            }
            commandOrSubGroupName = commandNames.get(i);
            findCommandPredicate = global.getParserConfiguration().allowsAbbreviatedCommands() ? new AbbreviatedCommandFinder(commandOrSubGroupName, (Collection<CommandMetadata>)group.getCommands()) : new CommandFinder(commandOrSubGroupName);
            command = (CommandMetadata)CollectionUtils.find(group.getCommands(), (Predicate)findCommandPredicate);
            if (command != null) {
                new CliCommandUsageGenerator().usage(global.getName(), UsageHelper.toGroupNames(groupPath), command.getName(), command, out);
                return;
            }
            if (global.getParserConfiguration().allowsAbbreviatedCommands()) {
                System.out.println("Unknown command " + name + " " + commandOrSubGroupName + " or an ambiguous abbreviation");
            } else {
                System.out.println("Unknown command " + name + " " + commandOrSubGroupName);
            }
        }
        findCommandPredicate = global.getParserConfiguration().allowsAbbreviatedCommands() ? new AbbreviatedCommandFinder(name, (Collection<CommandMetadata>)global.getDefaultGroupCommands()) : new CommandFinder(name);
        command = (CommandMetadata)CollectionUtils.find(global.getDefaultGroupCommands(), (Predicate)findCommandPredicate);
        if (command != null) {
            new CliCommandUsageGenerator(includeHidden).usage(global.getName(), null, command.getName(), command, out);
            return;
        }
        if (global.getParserConfiguration().allowsAbbreviatedCommands()) {
            System.out.println("Unknown command " + name + " or an ambiguous abbreviation");
        } else {
            System.out.println("Unknown command " + name);
        }
    }
}

