/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help;

import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class UsageHelper {
    public static final Comparator<OptionMetadata> DEFAULT_OPTION_COMPARATOR = new Comparator<OptionMetadata>(){

        @Override
        public int compare(OptionMetadata o1, OptionMetadata o2) {
            String option1 = o1.getOptions().iterator().next();
            option1 = option1.replaceFirst("^-+", "");
            String option2 = o2.getOptions().iterator().next();
            option2 = option2.replaceFirst("^-+", "");
            int c = option1.toLowerCase().compareTo(option2.toLowerCase());
            if (c == 0 && (c = option2.compareTo(option1)) == 0) {
                c = Integer.compare(System.identityHashCode(option1), System.identityHashCode(option2));
            }
            return c;
        }
    };
    public static final Comparator<CommandMetadata> DEFAULT_COMMAND_COMPARATOR = new Comparator<CommandMetadata>(){

        @Override
        public int compare(CommandMetadata command1, CommandMetadata command2) {
            int c = command1.getName().toLowerCase().compareTo(command2.getName().toLowerCase());
            if (c == 0 && (c = command2.getName().compareTo(command1.getName())) == 0) {
                c = Integer.compare(System.identityHashCode(command1), System.identityHashCode(command2));
            }
            return c;
        }
    };
    public static final Comparator<CommandGroupMetadata> DEFAULT_COMMAND_GROUP_COMPARATOR = new Comparator<CommandGroupMetadata>(){

        @Override
        public int compare(CommandGroupMetadata group1, CommandGroupMetadata group2) {
            int c = group1.getName().toLowerCase().compareTo(group2.getName().toLowerCase());
            if (c == 0 && (c = group2.getName().compareTo(group1.getName())) == 0) {
                c = Integer.compare(System.identityHashCode(group1), System.identityHashCode(group2));
            }
            return c;
        }
    };
    public static final Comparator<Map.Entry<Integer, String>> DEFAULT_EXIT_CODE_COMPARATOR = new Comparator<Map.Entry<Integer, String>>(){

        @Override
        public int compare(Map.Entry<Integer, String> o1, Map.Entry<Integer, String> o2) {
            int c = Integer.compare(o1.getKey(), o2.getKey());
            if (c == 0 && (c = o1.getValue().compareTo(o2.getValue())) == 0) {
                c = Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
            }
            return c;
        }
    };

    public static String[] toGroupNames(List<CommandGroupMetadata> groupPath) {
        String[] groupNames = new String[groupPath.size()];
        for (int i = 0; i < groupPath.size(); ++i) {
            groupNames[i] = groupPath.get(i).getName();
        }
        return groupNames;
    }
}

