/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.cli;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.common.AbstractPrintedCommandGroupUsageGenerator;
import com.github.rvesse.airline.io.printers.UsagePrinter;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class CliCommandGroupUsageGenerator<T>
extends AbstractPrintedCommandGroupUsageGenerator<T> {
    private final boolean hideGlobalOptions;

    public CliCommandGroupUsageGenerator() {
        this(79, false, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, false);
    }

    public CliCommandGroupUsageGenerator(boolean includeHidden) {
        this(79, false, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, includeHidden);
    }

    public CliCommandGroupUsageGenerator(int columns) {
        this(columns, false, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, false);
    }

    public CliCommandGroupUsageGenerator(int columns, boolean includeHidden) {
        this(columns, false, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, includeHidden);
    }

    public CliCommandGroupUsageGenerator(int columns, boolean hideGlobalOptions, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, boolean includeHidden) {
        super(columns, optionComparator, commandComparator, includeHidden);
        this.hideGlobalOptions = hideGlobalOptions;
    }

    @Override
    protected void usage(GlobalMetadata<T> global, CommandGroupMetadata[] groups, UsagePrinter out) throws IOException {
        this.outputDescription(out, global, groups);
        this.outputSynopsis(out, global, groups);
        this.outputOptions(out, global, groups);
    }

    protected void outputOptions(UsagePrinter out, GlobalMetadata<T> global, CommandGroupMetadata[] groups) throws IOException {
        List<OptionMetadata> options = new ArrayList<OptionMetadata>();
        options.addAll(groups[groups.length - 1].getOptions());
        if (global != null && !this.hideGlobalOptions) {
            options.addAll(global.getOptions());
        }
        if (options.size() > 0) {
            options = this.sortOptions(options);
            out.append("OPTIONS").newline();
            for (OptionMetadata option : options) {
                if (option.isHidden() && !this.includeHidden()) continue;
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append(this.toDescription(option)).newline();
                UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append(option.getDescription()).newline();
                descriptionPrinter.newline();
            }
        }
    }

    protected void outputSynopsis(UsagePrinter out, GlobalMetadata<T> global, CommandGroupMetadata[] groups) throws IOException {
        int i;
        out.append("SYNOPSIS").newline();
        UsagePrinter synopsis = out.newIndentedPrinter(8).newPrinterWithHangingIndent(8);
        CommandGroupMetadata group = groups[groups.length - 1];
        List<CommandMetadata> commands = this.sortCommands(group.getCommands());
        boolean hasDefaultCommand = group.getDefaultCommand() != null;
        ArrayList<OptionMetadata> commonGroupOptions = null;
        String commonGroupArgs = null;
        ArrayList<String> allCommandNames = new ArrayList<String>();
        ArrayList<String> groupNames = new ArrayList<String>();
        boolean hasCommandSpecificOptions = false;
        boolean hasCommandSpecificArgs = false;
        for (CommandMetadata command : commands) {
            if (group.getDefaultCommand() != null && group.getDefaultCommand().equals(command)) {
                allCommandNames.add(command.getName() + "*");
            } else {
                allCommandNames.add(command.getName());
            }
            if (commonGroupOptions == null) {
                commonGroupOptions = new ArrayList<OptionMetadata>(command.getCommandOptions());
            }
            if (commonGroupArgs == null) {
                commonGroupArgs = command.getArguments() != null ? this.toUsage(command.getArguments()) : "";
            }
            commonGroupOptions.retainAll(command.getCommandOptions());
            if (command.getCommandOptions().size() > commonGroupOptions.size()) {
                hasCommandSpecificOptions = true;
            }
            if (commonGroupArgs == (command.getArguments() != null ? this.toUsage(command.getArguments()) : "")) continue;
            hasCommandSpecificArgs = true;
        }
        for (CommandGroupMetadata subGroup : group.getSubGroups()) {
            groupNames.add(subGroup.getName());
            if (commonGroupOptions == null) {
                commonGroupOptions = new ArrayList<OptionMetadata>(subGroup.getOptions());
            }
            commonGroupOptions.retainAll(subGroup.getOptions());
        }
        if (global != null) {
            synopsis.append(global.getName());
            if (!this.hideGlobalOptions && commands.size() > 0) {
                synopsis.appendWords(this.toSynopsisUsage(commands.get(0).getGlobalOptions()));
            }
        }
        for (i = 0; i < groups.length; ++i) {
            synopsis.append(groups[i].getName()).append(" ");
        }
        if (commands.size() > 0) {
            synopsis.appendWords(this.toSynopsisUsage(commands.get(0).getGroupOptions()));
        }
        synopsis.append(" {");
        if (allCommandNames.size() > 0) {
            if (groupNames.size() > 0) {
                synopsis.append(" {");
            }
            for (i = 0; i < allCommandNames.size(); ++i) {
                synopsis.append((String)allCommandNames.get(i));
                if (i >= allCommandNames.size() - 1) continue;
                synopsis.append(" | ");
            }
        }
        if (groupNames.size() > 0) {
            if (allCommandNames.size() > 0) {
                synopsis.append("} | {");
            }
            for (i = 0; i < groupNames.size(); ++i) {
                synopsis.append((String)groupNames.get(i)).append(" <sub-command>");
                if (i >= groupNames.size() - 1) continue;
                synopsis.append(" | ");
            }
        }
        synopsis.append("} [--]");
        if (commonGroupOptions.size() > 0) {
            synopsis.appendWords(this.toSynopsisUsage(commonGroupOptions));
        }
        if (hasCommandSpecificOptions) {
            synopsis.append(" [cmd-options]");
        }
        if (hasCommandSpecificArgs) {
            synopsis.append(" <cmd-args>");
        }
        synopsis.newline();
        TreeMap<String, String> cmdOptions = new TreeMap<String, String>();
        TreeMap<String, String> cmdArguments = new TreeMap<String, String>();
        TreeMap<String, String> subGroups = new TreeMap<String, String>();
        for (CommandGroupMetadata subGroup : group.getSubGroups()) {
            if (subGroup.isHidden() && !this.includeHidden()) continue;
            StringBuilder groupSB = new StringBuilder();
            for (CommandGroupMetadata subSubGroup : subGroup.getSubGroups()) {
                if (groupSB.length() > 0) {
                    groupSB.append(", ");
                }
                groupSB.append(subSubGroup.getName()).append(' ').append("<sub-command>");
            }
            for (CommandMetadata subCommand : subGroup.getCommands()) {
                if (groupSB.length() > 0) {
                    groupSB.append(", ");
                }
                groupSB.append(subCommand.getName());
                if (subGroup.getDefaultCommand() == null || !subGroup.getDefaultCommand().equals(subCommand)) continue;
                groupSB.append("*");
                hasDefaultCommand = true;
            }
            subGroups.put(subGroup.getName(), groupSB.toString());
        }
        if (subGroups.size() > 0) {
            synopsis.newline().append("Where command groups contain the following sub-groups and commands:").newline();
            UsagePrinter grps = synopsis.newIndentedPrinter(4);
            for (String groupName : subGroups.keySet()) {
                grps.append(groupName + ": " + (String)subGroups.get(groupName)).newline();
            }
        }
        for (CommandMetadata command : commands) {
            if (command.isHidden() && !this.includeHidden()) continue;
            if (hasCommandSpecificOptions) {
                ArrayList<OptionMetadata> thisCmdOptions = new ArrayList<OptionMetadata>(command.getCommandOptions());
                thisCmdOptions.removeAll(commonGroupOptions);
                StringBuilder optSB = new StringBuilder();
                for (String s : this.toSynopsisUsage(thisCmdOptions)) {
                    optSB.append(s + " ");
                }
                cmdOptions.put(command.getName(), optSB.toString());
            }
            if (!hasCommandSpecificArgs) continue;
            cmdArguments.put(command.getName(), command.getArguments() != null ? this.toUsage(command.getArguments()) : "");
        }
        if (hasCommandSpecificOptions) {
            synopsis.newline().append("Where command-specific options [cmd-options] are:").newline();
            UsagePrinter opts = synopsis.newIndentedPrinter(4);
            for (String cmd : cmdOptions.keySet()) {
                opts.append(cmd + ": " + (String)cmdOptions.get(cmd)).newline();
            }
        }
        if (hasCommandSpecificArgs) {
            synopsis.newline().append("Where command-specific arguments <cmd-args> are:").newline();
            UsagePrinter args = synopsis.newIndentedPrinter(4);
            for (String arg : cmdArguments.keySet()) {
                args.append(arg + ": " + (String)cmdArguments.get(arg)).newline();
            }
        }
        if (hasDefaultCommand) {
            synopsis.newline().append("Where * indicates the default command(s)");
        }
        synopsis.newline().append("See").append("'" + global.getName()).append("help ").appendWords(UsageHelper.toGroupNames(AirlineUtils.arrayToList(groups))).appendOnOneLine(" <command>' for more information on a specific command.").newline();
    }

    protected void outputDescription(UsagePrinter out, GlobalMetadata<T> global, CommandGroupMetadata[] groups) throws IOException {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(global.getName()).append(" ");
        CommandGroupMetadata group = null;
        for (int i = 0; i < groups.length; ++i) {
            group = groups[i];
            out.append(group.getName());
            if (i >= groups.length - 1) continue;
            out.append(" ");
        }
        out.append(" - ").append(group.getDescription()).newline().newline();
    }
}

