/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.cli;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.cli.CliUsageHelper;
import com.github.rvesse.airline.help.common.AbstractPrintedCommandUsageGenerator;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.io.printers.UsagePrinter;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CliCommandUsageGenerator
extends AbstractPrintedCommandUsageGenerator {
    private final CliUsageHelper helper;

    public CliCommandUsageGenerator() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR, false);
    }

    public CliCommandUsageGenerator(boolean includeHidden) {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR, includeHidden);
    }

    public CliCommandUsageGenerator(int columns) {
        this(columns, UsageHelper.DEFAULT_OPTION_COMPARATOR, false);
    }

    public CliCommandUsageGenerator(int columns, boolean includeHidden) {
        this(columns, UsageHelper.DEFAULT_OPTION_COMPARATOR, includeHidden);
    }

    public CliCommandUsageGenerator(int columns, Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        super(columns, optionComparator, includeHidden);
        this.helper = this.createHelper(optionComparator, includeHidden);
    }

    protected CliUsageHelper createHelper(Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        return new CliUsageHelper(optionComparator, includeHidden);
    }

    @Override
    protected void usage(String programName, String[] groupNames, String commandName, CommandMetadata command, UsagePrinter out) throws IOException {
        this.outputDescription(out, programName, groupNames, commandName, command);
        ArrayList<HelpSection> preSections = new ArrayList<HelpSection>();
        ArrayList<HelpSection> postSections = new ArrayList<HelpSection>();
        this.findHelpSections(command, preSections, postSections);
        for (HelpSection section : preSections) {
            this.helper.outputHelpSection(out, section);
        }
        List<OptionMetadata> options = this.outputSynopsis(out, programName, groupNames, commandName, command);
        ArgumentsMetadata arguments = command.getArguments();
        if (options.size() > 0 || arguments != null) {
            this.outputOptionsAndArguments(out, command, options, arguments);
        }
        for (HelpSection section : postSections) {
            this.helper.outputHelpSection(out, section);
        }
    }

    protected void outputOptionsAndArguments(UsagePrinter out, CommandMetadata command, List<OptionMetadata> options, ArgumentsMetadata arguments) throws IOException {
        this.helper.outputOptions(out, options);
        this.helper.outputArguments(out, arguments);
    }

    protected List<OptionMetadata> outputSynopsis(UsagePrinter out, String programName, String[] groupNames, String commandName, CommandMetadata command) throws IOException {
        out.append("SYNOPSIS").newline();
        UsagePrinter synopsis = out.newIndentedPrinter(8).newPrinterWithHangingIndent(8);
        ArrayList<OptionMetadata> options = new ArrayList<OptionMetadata>();
        if (programName != null) {
            synopsis.append(programName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())));
            options.addAll(command.getGlobalOptions());
        }
        if (groupNames != null) {
            synopsis.appendWords(groupNames);
            synopsis.appendWords(this.toSynopsisUsage(this.sortOptions(command.getGroupOptions())));
            options.addAll(command.getGroupOptions());
        }
        synopsis.append(commandName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getCommandOptions())));
        options.addAll(command.getCommandOptions());
        if (command.getArguments() != null) {
            synopsis.append("[--]").append(this.toUsage(command.getArguments()));
        }
        synopsis.newline();
        synopsis.newline();
        return options;
    }

    protected void outputDescription(UsagePrinter out, String programName, String[] groupNames, String commandName, CommandMetadata command) throws IOException {
        out.append("NAME").newline();
        out = out.newIndentedPrinter(8).append(programName);
        if (groupNames != null) {
            out.appendWords(groupNames);
        }
        out.append(commandName).append("-").append(command.getDescription()).newline().newline();
    }
}

