/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.cli;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.cli.CliUsageHelper;
import com.github.rvesse.airline.help.common.AbstractPrintedGlobalUsageGenerator;
import com.github.rvesse.airline.io.printers.UsagePrinter;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

public class CliGlobalUsageGenerator<T>
extends AbstractPrintedGlobalUsageGenerator<T> {
    private final CliUsageHelper helper;

    public CliGlobalUsageGenerator() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public CliGlobalUsageGenerator(boolean includeHidden) {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public CliGlobalUsageGenerator(int columns) {
        this(columns, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public CliGlobalUsageGenerator(int columns, boolean includeHidden) {
        this(columns, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public CliGlobalUsageGenerator(int columnSize, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, Comparator<? super CommandGroupMetadata> commandGroupComparator, boolean includeHidden) {
        super(columnSize, optionComparator, commandComparator, commandGroupComparator, includeHidden);
        this.helper = this.createHelper(optionComparator, includeHidden);
    }

    protected CliUsageHelper createHelper(Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        return new CliUsageHelper(optionComparator, includeHidden);
    }

    @Override
    protected void usage(GlobalMetadata<T> global, UsagePrinter out) throws IOException {
        this.outputDescription(out, global);
        this.outputSynopsis(out, global);
        List<OptionMetadata> options = this.sortOptions(global.getOptions());
        if (options.size() > 0) {
            this.helper.outputOptions(out, options);
        }
        this.outputCommandList(out, global);
    }

    protected void outputCommandList(UsagePrinter out, GlobalMetadata<T> global) throws IOException {
        out.append("COMMANDS").newline();
        UsagePrinter commandPrinter = out.newIndentedPrinter(8);
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            this.outputCommandDescription(commandPrinter, null, command);
        }
        this.outputGroupCommandsList(commandPrinter, global, global.getCommandGroups());
    }

    protected void outputGroupCommandsList(UsagePrinter out, GlobalMetadata<T> global, List<CommandGroupMetadata> groups) throws IOException {
        if (groups.size() == 0) {
            return;
        }
        for (CommandGroupMetadata group : this.sortCommandGroups(groups)) {
            if (group.isHidden() && !this.includeHidden()) continue;
            for (CommandMetadata command : this.sortCommands(group.getCommands())) {
                this.outputCommandDescription(out, group, command);
            }
            if (group.getSubGroups().size() <= 0) continue;
            UsagePrinter subGroupPrinter = out.newIndentedPrinter(4);
            this.outputGroupCommandsList(subGroupPrinter, global, group.getSubGroups());
        }
    }

    protected void outputSynopsis(UsagePrinter out, GlobalMetadata<T> global) throws IOException {
        out.append("SYNOPSIS").newline();
        out.newIndentedPrinter(8).newPrinterWithHangingIndent(8).append(global.getName()).appendWords(this.toSynopsisUsage(global.getOptions())).append("<command> [ <args> ]").newline().newline();
    }

    protected void outputDescription(UsagePrinter out, GlobalMetadata<T> global) throws IOException {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(global.getName()).append("-").append(global.getDescription()).newline().newline();
    }

    protected void outputCommandDescription(UsagePrinter out, CommandGroupMetadata group, CommandMetadata command) throws IOException {
        if (!command.isHidden() || this.includeHidden()) {
            if (group != null) {
                out.append(group.getName());
            }
            out.append(command.getName()).newline();
            if (command.getDescription() != null) {
                out.newIndentedPrinter(4).append(command.getDescription()).newline();
            }
            out.newline();
        }
    }
}

