/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.cli;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.common.AbstractUsageGenerator;
import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.io.printers.UsagePrinter;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CliUsageHelper
extends AbstractUsageGenerator {
    public CliUsageHelper(Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        super(optionComparator, UsageHelper.DEFAULT_COMMAND_COMPARATOR, includeHidden);
    }

    public void outputOptions(UsagePrinter out, List<OptionMetadata> options) throws IOException {
        out.append("OPTIONS").newline();
        options = this.sortOptions(options);
        for (OptionMetadata option : options) {
            if (option.isHidden() && !this.includeHidden()) continue;
            UsagePrinter optionPrinter = out.newIndentedPrinter(8);
            optionPrinter.append(this.toDescription(option)).newline();
            optionPrinter.flush();
            UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
            descriptionPrinter.append(option.getDescription()).newline();
            for (OptionRestriction restriction : option.getRestrictions()) {
                if (!(restriction instanceof HelpHint)) continue;
                this.outputOptionRestriction(descriptionPrinter, option, restriction, (HelpHint)((Object)restriction));
            }
            descriptionPrinter.newline();
            descriptionPrinter.flush();
        }
    }

    protected void outputOptionRestriction(UsagePrinter out, OptionMetadata option, OptionRestriction restriction, HelpHint hint) throws IOException {
        out.newline();
        this.outputHint(out, hint, false);
    }

    protected void outputHint(UsagePrinter out, HelpHint hint, boolean newPara) throws IOException {
        if (hint.getFormat() == HelpFormat.NONE_PRINTABLE) {
            return;
        }
        if (!StringUtils.isBlank((CharSequence)hint.getPreamble())) {
            out.append(hint.getPreamble());
            out.newline();
            if (newPara) {
                out.newline();
            }
        }
        out.flush();
        if (hint.numContentBlocks() > 0) {
            switch (hint.getFormat()) {
                case EXAMPLES: {
                    for (int e = 0; e < hint.getContentBlock(0).length; ++e) {
                        out.appendOnOneLine(hint.getContentBlock(0)[e]);
                        out.newline().newline();
                        out.flush();
                        UsagePrinter examplePrinter = out.newIndentedPrinter(4);
                        for (int d = 1; d < hint.numContentBlocks(); ++d) {
                            String[] descriptions = hint.getContentBlock(d);
                            if (e >= descriptions.length) continue;
                            examplePrinter.append(descriptions[e]);
                            examplePrinter.newline().newline();
                        }
                        examplePrinter.flush();
                    }
                    break;
                }
                case TABLE: 
                case TABLE_WITH_HEADERS: {
                    int maxRows = CliUsageHelper.calculateMaxRows(hint);
                    ArrayList rows = new ArrayList();
                    for (int row = 0; row < maxRows; ++row) {
                        ArrayList<String> rowData = new ArrayList<String>();
                        for (int col = 0; col < hint.numContentBlocks(); ++col) {
                            String[] colData = hint.getContentBlock(col);
                            rowData.add(row < colData.length ? colData[row] : null);
                        }
                        rows.add(rowData);
                    }
                    UsagePrinter tablePrinter = out.newIndentedPrinter(4);
                    tablePrinter.appendTable(rows, 0);
                    tablePrinter.newline();
                    tablePrinter.flush();
                    break;
                }
                case LIST: {
                    UsagePrinter listPrinter = out.newIndentedPrinter(4);
                    for (String item : hint.getContentBlock(0)) {
                        listPrinter.append(item).newline();
                    }
                    listPrinter.flush();
                    break;
                }
                default: {
                    for (int i = 0; i < hint.numContentBlocks(); ++i) {
                        for (String line : hint.getContentBlock(i)) {
                            out.append(line);
                            out.newline().newline();
                        }
                    }
                }
            }
        }
    }

    public static int calculateMaxRows(HelpHint hint) {
        int maxRows = 0;
        for (int col = 0; col < hint.numContentBlocks(); ++col) {
            maxRows = Math.max(maxRows, hint.getContentBlock(col).length);
        }
        return maxRows;
    }

    public void outputArguments(UsagePrinter out, ArgumentsMetadata arguments) throws IOException {
        if (arguments != null) {
            UsagePrinter optionPrinter = out.newIndentedPrinter(8);
            optionPrinter.append("--").newline();
            optionPrinter.flush();
            UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
            descriptionPrinter.append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options)").newline();
            descriptionPrinter.newline();
            optionPrinter.append(this.toDescription(arguments)).newline();
            descriptionPrinter.append(arguments.getDescription()).newline();
            for (ArgumentsRestriction restriction : arguments.getRestrictions()) {
                if (!(restriction instanceof HelpHint)) continue;
                this.outputArgumentsRestriction(descriptionPrinter, arguments, restriction, (HelpHint)((Object)restriction));
            }
            descriptionPrinter.newline();
            descriptionPrinter.flush();
        }
    }

    protected void outputArgumentsRestriction(UsagePrinter descriptionPrinter, ArgumentsMetadata arguments, ArgumentsRestriction restriction, HelpHint hint) throws IOException {
        descriptionPrinter.newline();
        this.outputHint(descriptionPrinter, hint, false);
    }

    public void outputHelpSection(UsagePrinter out, HelpSection section) throws IOException {
        if (section.getFormat() == HelpFormat.NONE_PRINTABLE) {
            return;
        }
        if (!StringUtils.isBlank((CharSequence)section.getTitle())) {
            out.append(section.getTitle().toUpperCase());
            out.newline();
        }
        UsagePrinter sectionPrinter = out.newIndentedPrinter(8);
        this.outputHint(sectionPrinter, section, true);
        if (!StringUtils.isBlank((CharSequence)section.getPostamble())) {
            sectionPrinter.append(section.getPostamble());
            sectionPrinter.newline();
        }
        sectionPrinter.flush();
        out.flush();
    }
}

