/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.common;

import com.github.rvesse.airline.help.common.AbstractGlobalUsageGenerator;
import com.github.rvesse.airline.io.printers.UsagePrinter;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;

public abstract class AbstractPrintedGlobalUsageGenerator<T>
extends AbstractGlobalUsageGenerator<T> {
    private final int columns;

    public AbstractPrintedGlobalUsageGenerator(int columns, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, Comparator<? super CommandGroupMetadata> commandGroupComparator, boolean includeHidden) {
        super(optionComparator, commandComparator, commandGroupComparator, includeHidden);
        if (columns <= 0) {
            throw new IllegalArgumentException("columns must be greater than 0");
        }
        this.columns = columns;
    }

    protected abstract void usage(GlobalMetadata<T> var1, UsagePrinter var2) throws IOException;

    protected UsagePrinter createUsagePrinter(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("out cannot be null");
        }
        return new UsagePrinter(new PrintWriter(out), this.columns);
    }

    @Override
    public void usage(GlobalMetadata<T> global, OutputStream out) throws IOException {
        UsagePrinter printer = this.createUsagePrinter(out);
        this.usage(global, printer);
        printer.flush();
    }
}

