/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.html;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.common.AbstractCommandUsageGenerator;
import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HtmlCommandUsageGenerator
extends AbstractCommandUsageGenerator {
    public static final String DEFAULT_STYLESHEET = "css/bootstrap.min.css";
    protected static final String NEWLINE = "<br/>\n";
    protected final List<String> stylesheetUrls = new ArrayList<String>();

    public HtmlCommandUsageGenerator() {
        this(UsageHelper.DEFAULT_OPTION_COMPARATOR, false, DEFAULT_STYLESHEET);
    }

    public HtmlCommandUsageGenerator(boolean includeHidden) {
        this(UsageHelper.DEFAULT_OPTION_COMPARATOR, includeHidden, DEFAULT_STYLESHEET);
    }

    public HtmlCommandUsageGenerator(String stylesheetUrl, boolean includeHidden) {
        this(UsageHelper.DEFAULT_OPTION_COMPARATOR, includeHidden, stylesheetUrl);
    }

    public HtmlCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator, boolean includeHidden, String ... stylesheetUrls) {
        super(optionComparator, includeHidden);
        if (stylesheetUrls != null) {
            for (String stylesheet : stylesheetUrls) {
                if (!StringUtils.isNotEmpty((CharSequence)stylesheet)) continue;
                this.stylesheetUrls.add(stylesheet);
            }
        }
    }

    @Override
    public void usage(String programName, String[] groupNames, String commandName, CommandMetadata command, OutputStream output) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        this.outputHtmlHeader(writer);
        ((Writer)writer).append("<body>\n");
        this.outputPageHeader(writer, programName, groupNames, command);
        this.outputDescription(writer, programName, groupNames, command);
        List<OptionMetadata> options = this.outputSynopsis(writer, programName, groupNames, command);
        if (options.size() > 0 || command.getArguments() != null) {
            options = this.sortOptions(options);
            this.outputOptions(writer, options, command.getArguments());
        }
        ((Writer)writer).append("</body>\n");
        ((Writer)writer).append("</html>\n");
        ((Writer)writer).flush();
        output.flush();
    }

    protected void outputOptions(Writer writer, List<OptionMetadata> options, ArgumentsMetadata arguments) throws IOException {
        writer.append(NEWLINE);
        writer.append("<h1 class=\"text-info\">OPTIONS</h1>\n").append(NEWLINE);
        for (OptionMetadata option : options) {
            if (option.isHidden() && !this.includeHidden()) continue;
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset1\">\n");
            writer.append(this.htmlize(this.toDescription(option)));
            writer.append("</div>\n");
            writer.append("</div>\n");
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset2\">\n");
            writer.append(this.htmlize(option.getDescription()));
            writer.append("</div>\n");
            writer.append("</div>\n");
            for (OptionRestriction restriction : option.getRestrictions()) {
                if (!(restriction instanceof HelpHint)) continue;
                this.outputOptionRestriction(writer, option, restriction, (HelpHint)((Object)restriction));
            }
        }
        if (arguments != null) {
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset1\">\n");
            writer.append("--").append("\n");
            writer.append("</div>\n");
            writer.append("</div>\n");
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset2\">\n");
            writer.append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options)\n");
            writer.append("</div>\n");
            writer.append("</div>\n");
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset1\">\n");
            writer.append(this.htmlize(this.toDescription(arguments)));
            writer.append("</div>\n");
            writer.append("</div>\n");
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset2\">\n");
            writer.append(this.htmlize(arguments.getDescription()));
            writer.append("</div>\n");
            writer.append("</div>\n");
        }
    }

    protected void outputOptionRestriction(Writer writer, OptionMetadata option, OptionRestriction restriction, HelpHint hint) throws IOException {
        writer.append("<div class=\"row\">\n");
        writer.append("<div class=\"span8 offset3\">\n");
        if (!StringUtils.isEmpty((CharSequence)hint.getPreamble())) {
            writer.append(this.htmlize(hint.getPreamble()));
            writer.append(NEWLINE);
        }
        if (hint.numContentBlocks() > 0) {
            switch (hint.getFormat()) {
                case EXAMPLES: {
                    String[] examples = hint.getContentBlock(0);
                    for (int i = 0; i < examples.length; ++i) {
                        writer.append("<pre>");
                        writer.append(examples[i]);
                        writer.append("</pre>").append(NEWLINE);
                        for (int j = 1; j < hint.numContentBlocks(); ++j) {
                            String[] explanations = hint.getContentBlock(j);
                            if (i >= explanations.length) continue;
                            writer.append("<p>").append(NEWLINE);
                            writer.append(this.htmlize(explanations[i]));
                            writer.append("</p>").append(NEWLINE);
                        }
                    }
                    break;
                }
                case LIST: {
                    writer.append("<ul>").append(NEWLINE);
                    for (String item : hint.getContentBlock(0)) {
                        writer.append("<li>");
                        writer.append(this.htmlize(item));
                        writer.append("</li>").append(NEWLINE);
                    }
                    writer.append("</ul>");
                    break;
                }
                case TABLE: 
                case TABLE_WITH_HEADERS: {
                    boolean useHeaders = hint.getFormat() == HelpFormat.TABLE_WITH_HEADERS;
                    int maxRows = 0;
                    for (int col = 0; col < hint.numContentBlocks(); ++col) {
                        maxRows = Math.max(maxRows, hint.getContentBlock(col).length);
                    }
                    writer.append("<table>").append(NEWLINE);
                    for (int row = 0; row < maxRows; ++row) {
                        writer.append("<tr>").append(NEWLINE);
                        for (int col = 0; col < hint.numContentBlocks(); ++col) {
                            String[] colData = hint.getContentBlock(col);
                            writer.append(useHeaders ? "<th>" : "<td>");
                            if (row < colData.length) {
                                writer.append(this.htmlize(colData[row]));
                            }
                            writer.append(useHeaders ? "</th>" : "</td>");
                            writer.append(NEWLINE);
                        }
                        useHeaders = false;
                        writer.append("</tr>").append(NEWLINE);
                    }
                    writer.append("</table>").append(NEWLINE);
                    break;
                }
                default: {
                    for (int i = 0; i < hint.numContentBlocks(); ++i) {
                        for (String para : hint.getContentBlock(i)) {
                            writer.append("<p>").append(NEWLINE);
                            writer.append(this.htmlize(para));
                            writer.append("</p>").append(NEWLINE);
                        }
                    }
                }
            }
        }
        writer.append("</div>\n");
        writer.append("</div>\n");
    }

    protected List<OptionMetadata> outputSynopsis(Writer writer, String programName, String[] groupNames, CommandMetadata command) throws IOException {
        writer.append("<h1 class=\"text-info\">SYNOPSIS</h1>\n").append(NEWLINE);
        ArrayList<OptionMetadata> options = new ArrayList<OptionMetadata>();
        writer.append("<div class=\"row\">\n");
        writer.append("<div class=\"span8 offset1\">\n");
        if (programName != null) {
            writer.append(this.htmlize(programName)).append(" ").append(this.htmlize(StringUtils.join(this.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())), (char)' ')));
            options.addAll(command.getGlobalOptions());
        }
        if (groupNames != null) {
            for (int i = 0; i < groupNames.length; ++i) {
                writer.append(this.htmlize(groupNames[i])).append(" ");
            }
            writer.append(this.htmlize(StringUtils.join(this.toSynopsisUsage(this.sortOptions(command.getGroupOptions())), (char)' ')));
            options.addAll(command.getGroupOptions());
        }
        writer.append(this.htmlize(command.getName())).append(" ").append(this.htmlize(StringUtils.join(this.toSynopsisUsage(this.sortOptions(command.getCommandOptions())), (char)' ')));
        options.addAll(command.getCommandOptions());
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            writer.append(" [--] ").append(this.htmlize(this.toUsage(arguments)));
        }
        writer.append("</div>\n");
        writer.append("</div>\n");
        return options;
    }

    protected void outputDescription(Writer writer, String programName, String[] groupNames, CommandMetadata command) throws IOException {
        writer.append("<h2 class=\"text-info\">NAME</h1>\n").append(NEWLINE);
        writer.append("<div class=\"row\">");
        writer.append("<div class=\"span8 offset1\">");
        writer.append(this.htmlize(programName)).append(" ");
        if (groupNames != null) {
            for (int i = 0; i < groupNames.length; ++i) {
                writer.append(this.htmlize(groupNames[i])).append(" ");
            }
        }
        writer.append(this.htmlize(command.getName())).append(" ");
        writer.append("&mdash;");
        writer.append(this.htmlize(command.getDescription()));
        writer.append("</div>\n");
        writer.append("</div>\n");
        writer.append(NEWLINE);
    }

    protected void outputPageHeader(Writer writer, String programName, String[] groupNames, CommandMetadata command) throws IOException {
        writer.append("<hr/>\n");
        writer.append("<h1 class=\"text-info\">").append(this.htmlize(programName)).append(" ");
        if (groupNames != null) {
            for (int i = 0; i < groupNames.length; ++i) {
                writer.append(this.htmlize(groupNames[i])).append(" ");
            }
        }
        writer.append(this.htmlize(command.getName())).append(" Manual Page\n");
        writer.append("<hr/>\n");
    }

    protected void outputHtmlHeader(Writer writer) throws IOException {
        writer.append("<html>\n");
        writer.append("<head>\n");
        this.outputStylesheets(writer);
        writer.append("<style>\n");
        this.outputAdditionalCss(writer);
        writer.append("</style>\n");
        writer.append("</head>\n");
    }

    protected void outputAdditionalCss(Writer writer) throws IOException {
        writer.append("    body { margin: 50px; }\n");
    }

    protected void outputStylesheets(Writer writer) throws IOException {
        for (String stylesheet : this.stylesheetUrls) {
            writer.append("<link href=\"").append(stylesheet).append("\" rel=\"stylesheet\">\n");
        }
    }
}

