/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.ronn;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.common.AbstractCommandUsageGenerator;
import com.github.rvesse.airline.help.ronn.RonnUsageHelper;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RonnCommandUsageGenerator
extends AbstractCommandUsageGenerator {
    private final int manSection;
    private final boolean standalone;
    private final RonnUsageHelper helper;

    public RonnCommandUsageGenerator() {
        this(1, false, true);
    }

    public RonnCommandUsageGenerator(int manSection, boolean includeHidden, boolean standalone) {
        super(includeHidden);
        this.manSection = manSection;
        this.standalone = standalone;
        this.helper = this.createHelper(includeHidden);
    }

    protected RonnUsageHelper createHelper(boolean includeHidden) {
        return new RonnUsageHelper(UsageHelper.DEFAULT_OPTION_COMPARATOR, includeHidden);
    }

    @Override
    public void usage(String programName, String[] groupNames, String commandName, CommandMetadata command, OutputStream output) throws IOException {
        String sectionHeader = "## ";
        if (commandName == null) {
            commandName = command.getName();
        }
        OutputStreamWriter writer = new OutputStreamWriter(output);
        sectionHeader = this.outputTitle(writer, programName, groupNames, commandName, command, sectionHeader);
        ArrayList<HelpSection> preSections = new ArrayList<HelpSection>();
        ArrayList<HelpSection> postSections = new ArrayList<HelpSection>();
        this.findHelpSections(command, preSections, postSections);
        for (HelpSection section : preSections) {
            this.helper.outputHelpSection(writer, section, sectionHeader);
        }
        List<OptionMetadata> options = this.outputSynopsis(writer, programName, groupNames, commandName, command, sectionHeader);
        if (options.size() > 0 || command.getArguments() != null) {
            this.outputOptions(writer, command, options, sectionHeader);
        }
        for (HelpSection section : postSections) {
            this.helper.outputHelpSection(writer, section, sectionHeader);
        }
        ((Writer)writer).flush();
        output.flush();
    }

    protected void outputOptions(Writer writer, CommandMetadata command, List<OptionMetadata> options, String sectionHeader) throws IOException {
        this.helper.outputOptions(writer, options, sectionHeader);
        this.helper.outputArguments(writer, command);
    }

    protected List<OptionMetadata> outputSynopsis(Writer writer, String programName, String[] groupNames, String commandName, CommandMetadata command, String sectionHeader) throws IOException {
        List<OptionMetadata> aOptions;
        writer.append("\n\n").append(sectionHeader).append("SYNOPSIS").append("\n\n");
        ArrayList<OptionMetadata> options = new ArrayList<OptionMetadata>();
        if (programName != null) {
            writer.append("`").append(programName).append("`");
            aOptions = command.getGlobalOptions();
            if (aOptions != null && aOptions.size() > 0) {
                writer.append(" ").append(StringUtils.join(this.toSynopsisUsage(this.sortOptions(aOptions)), (char)' '));
                options.addAll(aOptions);
            }
        }
        if (groupNames != null) {
            for (int i = 0; i < groupNames.length; ++i) {
                writer.append(" `").append(groupNames[i]).append("`");
            }
            aOptions = command.getGroupOptions();
            if (aOptions != null && aOptions.size() > 0) {
                writer.append(" ").append(StringUtils.join(this.toSynopsisUsage(this.sortOptions(aOptions)), (char)' '));
                options.addAll(aOptions);
            }
        }
        aOptions = command.getCommandOptions();
        writer.append(" `").append(commandName).append("` ").append(StringUtils.join(this.toSynopsisUsage(this.sortOptions(aOptions)), (char)' '));
        options.addAll(aOptions);
        if (command.getArguments() != null) {
            writer.append(" [--] ").append(this.toUsage(command.getArguments()));
        }
        if (!this.standalone) {
            writer.append("\n\n").append(command.getDescription());
        }
        return options;
    }

    protected String outputTitle(Writer writer, String programName, String[] groupNames, String commandName, CommandMetadata command, String sectionHeader) throws IOException {
        if (!this.standalone) {
            writer.append(sectionHeader);
            sectionHeader = "#" + sectionHeader;
        }
        this.writeFullCommandName(programName, groupNames, commandName, writer);
        if (this.standalone) {
            writer.append(" -- ");
            writer.append(command.getDescription()).append("\n");
            writer.append("==========");
        }
        return sectionHeader;
    }

    protected void writeFullCommandName(String programName, String[] groupNames, String commandName, Writer writer) throws IOException {
        if (programName != null) {
            writer.append(programName).append("-");
        }
        if (groupNames != null) {
            for (int i = 0; i < groupNames.length; ++i) {
                writer.append(groupNames[i]).append("-");
            }
        }
        writer.append(commandName).append("(").append(Integer.toString(this.manSection)).append(")");
    }

    @Override
    protected String toDescription(OptionMetadata option) {
        Set<String> options = option.getOptions();
        StringBuilder stringBuilder = new StringBuilder();
        String argumentString = option.getArity() > 0 ? String.format("<%s>", option.getTitle()) : null;
        boolean first = true;
        for (String name : options) {
            if (!first) {
                stringBuilder.append(", ");
            } else {
                first = false;
            }
            stringBuilder.append('`').append(name).append('`');
            if (argumentString == null) continue;
            stringBuilder.append(' ').append(argumentString);
        }
        return stringBuilder.toString();
    }
}

