/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.ronn;

import com.github.rvesse.airline.help.CommandUsageGenerator;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.common.AbstractGlobalUsageGenerator;
import com.github.rvesse.airline.help.ronn.RonnCommandUsageGenerator;
import com.github.rvesse.airline.help.ronn.RonnUsageHelper;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RonnGlobalUsageGenerator<T>
extends AbstractGlobalUsageGenerator<T> {
    protected final CommandUsageGenerator commandUsageGenerator;
    protected final int manSection;
    protected final RonnUsageHelper helper;

    public RonnGlobalUsageGenerator() {
        this(1, false, new RonnCommandUsageGenerator(1, false, false));
    }

    public RonnGlobalUsageGenerator(int manSection) {
        this(manSection, false, new RonnCommandUsageGenerator(manSection, false, false));
    }

    public RonnGlobalUsageGenerator(int manSection, boolean includeHidden) {
        this(manSection, includeHidden, new RonnCommandUsageGenerator(manSection, includeHidden, false));
    }

    protected RonnGlobalUsageGenerator(int manSection, boolean includeHidden, CommandUsageGenerator commandUsageGenerator) {
        super(includeHidden);
        this.commandUsageGenerator = commandUsageGenerator;
        this.manSection = manSection;
        this.helper = this.createHelper(includeHidden);
    }

    protected RonnUsageHelper createHelper(boolean includeHidden) {
        return new RonnUsageHelper(UsageHelper.DEFAULT_OPTION_COMPARATOR, includeHidden);
    }

    @Override
    public void usage(GlobalMetadata<T> global, OutputStream output) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        this.outputTitle(global, writer);
        List<OptionMetadata> options = new ArrayList<OptionMetadata>();
        if (global.getOptions() != null && global.getOptions().size() > 0) {
            options.addAll(global.getOptions());
            options = this.sortOptions(options);
        }
        this.outputSynopsis(writer, global);
        if (options.size() > 0) {
            this.helper.outputOptions(writer, options, "## ");
        }
        ((Writer)writer).flush();
        output.flush();
        if (global.getCommandGroups().size() > 0) {
            this.outputGroupCommandList(writer, global);
            this.outputCommandUsages(output, writer, global);
        } else {
            this.outputCommandList(writer, global);
            this.outputCommandUsages(output, writer, global);
        }
        ((Writer)writer).flush();
        output.flush();
    }

    protected void outputGroupCommandList(Writer writer, GlobalMetadata<T> global) throws IOException {
        writer.append("\n\n").append("## COMMAND GROUPS").append("\n\n");
        writer.append("Commands are grouped as follows:");
        if (global.getDefaultGroupCommands().size() > 0) {
            writer.append("\n\n").append("* Default (no <group> specified)");
            for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
                if (command.isHidden() && !this.includeHidden()) continue;
                writer.append("\n\n").append("  * `").append(this.getCommandName(global, null, command)).append("`:\n");
                writer.append("  ").append(command.getDescription());
            }
        }
        this.outputGroupCommandsList(writer, global, global.getCommandGroups(), 0);
    }

    protected void outputGroupCommandsList(Writer writer, GlobalMetadata<T> global, List<CommandGroupMetadata> groups, int indent) throws IOException {
        if (groups.size() == 0) {
            return;
        }
        String indentStr = StringUtils.repeat((char)' ', (int)indent);
        for (CommandGroupMetadata group : this.sortCommandGroups(groups)) {
            if (group.isHidden() && !this.includeHidden()) continue;
            writer.append("\n\n").append(indentStr).append("* **").append(group.getName()).append("**").append("\n\n");
            writer.append("  ").append(group.getDescription());
            for (CommandMetadata command : this.sortCommands(group.getCommands())) {
                if (command.isHidden() && !this.includeHidden()) continue;
                writer.append("\n\n").append(indentStr).append("  * `").append(this.getCommandName(global, new String[]{group.getName()}, command)).append("`:\n");
                writer.append("  ").append(command.getDescription());
            }
            this.outputGroupCommandsList(writer, global, group.getSubGroups(), indent + 4);
        }
    }

    protected void outputCommandList(Writer writer, GlobalMetadata<T> global) throws IOException {
        writer.append("\n\n").append("## COMMANDS");
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            if (command.isHidden() && !this.includeHidden()) continue;
            writer.append("\n\n").append("* `").append(this.getCommandName(global, null, command)).append("`:\n");
            writer.append(command.getDescription());
        }
    }

    protected void outputSynopsis(Writer writer, GlobalMetadata<T> global) throws IOException {
        writer.append("\n\n").append("## SYNOPSIS").append("\n\n");
        writer.append("`").append(global.getName()).append("`");
        if (global.getOptions() != null && global.getOptions().size() > 0) {
            writer.append(" ").append(StringUtils.join(this.toSynopsisUsage(this.sortOptions(global.getOptions())), (char)' '));
        }
        if (global.getCommandGroups().size() > 0) {
            writer.append(" [<group>] <command> [command-args]");
        } else {
            writer.append(" <command> [command-args]");
        }
    }

    protected void outputTitle(GlobalMetadata<T> global, Writer writer) throws IOException {
        writer.append(global.getName()).append("(").append(Integer.toString(this.manSection)).append(") -- ");
        writer.append(global.getDescription()).append("\n");
        writer.append("==========");
    }

    protected void outputCommandUsages(OutputStream output, Writer writer, GlobalMetadata<T> global) throws IOException {
        writer.append("\n\n").append("---").append("\n\n");
        this.outputDefaultGroupCommandUsages(output, writer, global);
        for (CommandGroupMetadata group : this.sortCommandGroups(global.getCommandGroups())) {
            if (group.isHidden() && !this.includeHidden()) continue;
            ArrayList<CommandGroupMetadata> groupPath = new ArrayList<CommandGroupMetadata>();
            groupPath.add(group);
            this.outputGroupCommandUsages(output, writer, global, groupPath);
        }
    }

    protected String getCommandName(GlobalMetadata<T> global, String[] groupNames, CommandMetadata command) {
        return command.getName();
    }

    protected void outputGroupCommandUsages(OutputStream output, Writer writer, GlobalMetadata<T> global, List<CommandGroupMetadata> groups) throws IOException {
        CommandGroupMetadata group = groups.get(groups.size() - 1);
        for (CommandMetadata command : this.sortCommands(group.getCommands())) {
            if (command.isHidden() && !this.includeHidden()) continue;
            writer.flush();
            output.flush();
            this.commandUsageGenerator.usage(global.getName(), UsageHelper.toGroupNames(groups), command.getName(), command, output);
            writer.append("\n\n").append("---").append("\n\n");
        }
        for (CommandGroupMetadata subGroup : this.sortCommandGroups(group.getSubGroups())) {
            if (subGroup.isHidden() && !this.includeHidden()) continue;
            List<CommandGroupMetadata> subGroupPath = AirlineUtils.listCopy(groups);
            subGroupPath.add(subGroup);
            this.outputGroupCommandUsages(output, writer, global, subGroupPath);
        }
    }

    protected void outputDefaultGroupCommandUsages(OutputStream output, Writer writer, GlobalMetadata<T> global) throws IOException {
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            if (command.isHidden() && !this.includeHidden()) continue;
            writer.flush();
            output.flush();
            this.commandUsageGenerator.usage(global.getName(), null, command.getName(), command, output);
            writer.append("\n\n").append("---").append("\n\n");
        }
    }

    @Override
    protected String toDescription(OptionMetadata option) {
        Set<String> options = option.getOptions();
        StringBuilder stringBuilder = new StringBuilder();
        String argumentString = option.getArity() > 0 ? String.format("<%s>", option.getTitle()) : null;
        boolean first = true;
        for (String name : options) {
            if (!first) {
                stringBuilder.append(", ");
            } else {
                first = false;
            }
            stringBuilder.append('`').append(name).append('`');
            if (argumentString == null) continue;
            stringBuilder.append(' ').append(argumentString);
        }
        return stringBuilder.toString();
    }
}

