/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.ronn;

import com.github.rvesse.airline.help.CommandUsageGenerator;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.ronn.RonnCommandUsageGenerator;
import com.github.rvesse.airline.help.ronn.RonnGlobalUsageGenerator;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class RonnMultiPageGlobalUsageGenerator<T>
extends RonnGlobalUsageGenerator<T> {
    public RonnMultiPageGlobalUsageGenerator() {
        this(1, false, new RonnCommandUsageGenerator(1, false, true));
    }

    public RonnMultiPageGlobalUsageGenerator(int manSection) {
        this(manSection, false, new RonnCommandUsageGenerator(manSection, false, true));
    }

    public RonnMultiPageGlobalUsageGenerator(int manSection, boolean includeHidden) {
        this(manSection, includeHidden, new RonnCommandUsageGenerator(manSection, includeHidden, true));
    }

    protected RonnMultiPageGlobalUsageGenerator(int manSection, boolean includeHidden, CommandUsageGenerator commandUsageGenerator) {
        super(manSection, includeHidden, commandUsageGenerator);
    }

    @Override
    protected String getCommandName(GlobalMetadata<T> global, String[] groupNames, CommandMetadata command) {
        StringBuilder name = new StringBuilder();
        name.append(global.getName()).append("-");
        if (groupNames != null) {
            for (int i = 0; i < groupNames.length; ++i) {
                name.append(groupNames[i]).append("-");
            }
        }
        name.append(command.getName());
        name.append("(").append(Integer.toString(this.manSection)).append(")");
        return name.toString();
    }

    @Override
    protected void outputCommandUsages(OutputStream output, Writer writer, GlobalMetadata<T> global) throws IOException {
        this.outputDefaultGroupCommandUsages(output, writer, global);
        for (CommandGroupMetadata group : this.sortCommandGroups(global.getCommandGroups())) {
            if (group.isHidden() && !this.includeHidden()) continue;
            ArrayList<CommandGroupMetadata> groupPath = new ArrayList<CommandGroupMetadata>();
            groupPath.add(group);
            this.outputGroupCommandUsages(output, writer, global, groupPath);
        }
    }

    @Override
    protected void outputGroupCommandUsages(OutputStream output, Writer writer, GlobalMetadata<T> global, List<CommandGroupMetadata> groups) throws IOException {
        CommandGroupMetadata group = groups.get(groups.size() - 1);
        for (CommandMetadata command : this.sortCommands(group.getCommands())) {
            if (command.isHidden() && !this.includeHidden()) continue;
            output = this.createCommandFile(global, UsageHelper.toGroupNames(groups), command);
            writer = new OutputStreamWriter(output);
            this.commandUsageGenerator.usage(global.getName(), UsageHelper.toGroupNames(groups), command.getName(), command, output);
            this.outputReferenceToSuite(global, writer);
            writer.flush();
            output.flush();
            writer.close();
            output.close();
        }
        for (CommandGroupMetadata subGroup : this.sortCommandGroups(group.getSubGroups())) {
            if (subGroup.isHidden() && !this.includeHidden()) continue;
            List<CommandGroupMetadata> subGroupPath = AirlineUtils.listCopy(groups);
            subGroupPath.add(subGroup);
            this.outputGroupCommandUsages(output, writer, global, subGroupPath);
        }
    }

    protected void outputReferenceToSuite(GlobalMetadata<T> global, Writer writer) throws IOException {
        writer.append("\n\n").append("## ").append(global.getName().toUpperCase()).append("\n\n");
        writer.append("Part of the `").append(global.getName()).append("(").append(Integer.toString(this.manSection)).append(")` suite");
    }

    protected FileOutputStream createCommandFile(GlobalMetadata<T> global, String[] groupNames, CommandMetadata command) throws FileNotFoundException {
        return new FileOutputStream(this.getCommandName(global, groupNames, command).replace(String.format("(%d)", this.manSection), String.format(".%d.ronn", this.manSection)));
    }

    @Override
    protected void outputDefaultGroupCommandUsages(OutputStream output, Writer writer, GlobalMetadata<T> global) throws IOException {
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            if (command.isHidden() && !this.includeHidden()) continue;
            output = this.createCommandFile(global, null, command);
            writer = new OutputStreamWriter(output);
            this.commandUsageGenerator.usage(global.getName(), null, command.getName(), command, output);
            this.outputReferenceToSuite(global, writer);
            writer.flush();
            output.flush();
            writer.close();
            output.close();
        }
    }
}

