/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.ronn;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.cli.CliUsageHelper;
import com.github.rvesse.airline.help.common.AbstractUsageGenerator;
import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.io.printers.UsagePrinter;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RonnUsageHelper
extends AbstractUsageGenerator {
    public static final String NEW_PARA = "\n\n";
    public static final String HORIZONTAL_RULE = "---";

    public RonnUsageHelper(Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        super(optionComparator, UsageHelper.DEFAULT_COMMAND_COMPARATOR, includeHidden);
    }

    public void outputArguments(Writer writer, CommandMetadata command) throws IOException {
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            writer.append(NEW_PARA).append("* `").append("--").append("`:\n");
            writer.append("This option can be used to separate command-line options from the list of arguments (useful when arguments might be mistaken for command-line options).");
            writer.append(NEW_PARA).append("* ").append(this.toDescription(arguments)).append(":\n");
            writer.append(arguments.getDescription());
            for (ArgumentsRestriction restriction : arguments.getRestrictions()) {
                if (!(restriction instanceof HelpHint)) continue;
                this.outputArgumentsRestriction(writer, arguments, restriction, (HelpHint)((Object)restriction));
            }
        }
    }

    protected void outputArgumentsRestriction(Writer writer, ArgumentsMetadata arguments, ArgumentsRestriction restriction, HelpHint hint) throws IOException {
        this.outputHint(writer, hint, true, 2);
    }

    public void outputOptions(Writer writer, List<OptionMetadata> options, String sectionHeader) throws IOException {
        writer.append(NEW_PARA).append(sectionHeader).append("OPTIONS");
        options = this.sortOptions(options);
        for (OptionMetadata option : options) {
            if (option.isHidden() && !this.includeHidden()) continue;
            writer.append(NEW_PARA).append("* ").append(this.toDescription(option)).append(":\n");
            writer.append("  ").append(option.getDescription());
            for (OptionRestriction restriction : option.getRestrictions()) {
                if (!(restriction instanceof HelpHint)) continue;
                this.outputOptionRestriction(writer, option, restriction, (HelpHint)((Object)restriction));
            }
        }
    }

    protected void outputOptionRestriction(Writer writer, OptionMetadata option, OptionRestriction restriction, HelpHint hint) throws IOException {
        this.outputHint(writer, hint, true, 2);
    }

    protected void outputHint(Writer writer, HelpHint hint, boolean requireNewPara, int baseIndent) throws IOException {
        if (hint.getFormat() == HelpFormat.NONE_PRINTABLE) {
            return;
        }
        UsagePrinter printer = new UsagePrinter(new PrintWriter(writer), Integer.MAX_VALUE);
        if (baseIndent > 0) {
            printer = printer.newIndentedPrinter(baseIndent);
        }
        if (requireNewPara) {
            printer.newline().newline();
        }
        if (!StringUtils.isBlank((CharSequence)hint.getPreamble())) {
            printer.append(hint.getPreamble());
            printer.newline().newline();
        }
        switch (hint.getFormat()) {
            case EXAMPLES: {
                String[] examples = hint.getContentBlock(0);
                for (int e = 0; e < examples.length; ++e) {
                    printer.flush();
                    UsagePrinter examplePrinter = printer.newIndentedPrinter(4);
                    examplePrinter.appendOnOneLine(examples[e]);
                    examplePrinter.newline().newline();
                    examplePrinter.flush();
                    for (int d = 1; d < hint.numContentBlocks(); ++d) {
                        String[] descriptions = hint.getContentBlock(d);
                        if (e >= descriptions.length) continue;
                        printer.append(descriptions[e]);
                        printer.newline().newline();
                        printer.flush();
                    }
                }
                break;
            }
            case TABLE: 
            case TABLE_WITH_HEADERS: {
                int maxRows = CliUsageHelper.calculateMaxRows(hint);
                for (int row = 0; row < maxRows; ++row) {
                    printer.append("* ");
                    for (int col = 0; col < hint.numContentBlocks(); ++col) {
                        String[] colData = hint.getContentBlock(col);
                        if (row >= colData.length || StringUtils.isEmpty((CharSequence)colData[row])) continue;
                        if (col > 0) {
                            printer.append(" - ");
                        }
                        if (col == 0 || row == 0 && hint.getFormat() == HelpFormat.TABLE_WITH_HEADERS) {
                            printer.append("**");
                        }
                        printer.append(colData[row]);
                        if (col != 0 && (row != 0 || hint.getFormat() != HelpFormat.TABLE_WITH_HEADERS)) continue;
                        printer.append("**");
                    }
                    printer.newline();
                }
                break;
            }
            case LIST: {
                if (!requireNewPara && StringUtils.isBlank((CharSequence)hint.getPreamble())) {
                    printer.newline().newline();
                }
                String[] items = hint.getContentBlock(0);
                for (int i = 0; i < items.length; ++i) {
                    UsagePrinter listPrinter = printer.newIndentedPrinter(7);
                    listPrinter.append(items[i]).newline();
                    listPrinter.flush();
                }
                break;
            }
            default: {
                for (int i = 0; i < hint.numContentBlocks(); ++i) {
                    for (String para : hint.getContentBlock(i)) {
                        printer.append(para);
                        printer.newline().newline();
                    }
                }
            }
        }
        printer.flush();
        writer.flush();
    }

    @Override
    protected String toDescription(OptionMetadata option) {
        Set<String> options = option.getOptions();
        StringBuilder stringBuilder = new StringBuilder();
        String argumentString = option.getArity() > 0 ? String.format("<%s>", option.getTitle()) : null;
        boolean first = true;
        for (String name : options) {
            if (!first) {
                stringBuilder.append(", ");
            } else {
                first = false;
            }
            stringBuilder.append('`').append(name).append('`');
            if (argumentString == null) continue;
            stringBuilder.append(' ').append(argumentString);
        }
        return stringBuilder.toString();
    }

    public void outputHelpSection(Writer writer, HelpSection section, String sectionHeader) throws IOException {
        if (section.getFormat() == HelpFormat.NONE_PRINTABLE) {
            return;
        }
        if (!StringUtils.isBlank((CharSequence)section.getTitle())) {
            writer.append(NEW_PARA).append(sectionHeader);
            writer.append(section.getTitle().toUpperCase());
            writer.append(NEW_PARA);
        } else {
            writer.append(NEW_PARA);
        }
        this.outputHint(writer, section, false, 0);
        if (!StringUtils.isBlank((CharSequence)section.getPostamble())) {
            writer.append(section.getPostamble());
            writer.append(NEW_PARA);
        }
        writer.flush();
    }
}

