/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.sections.factories;

import com.github.rvesse.airline.annotations.help.Discussion;
import com.github.rvesse.airline.annotations.help.Examples;
import com.github.rvesse.airline.annotations.help.ExitCodes;
import com.github.rvesse.airline.annotations.help.HideSection;
import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.help.sections.common.BasicSection;
import com.github.rvesse.airline.help.sections.common.DiscussionSection;
import com.github.rvesse.airline.help.sections.common.ExamplesSection;
import com.github.rvesse.airline.help.sections.common.ExitCodesSection;
import com.github.rvesse.airline.help.sections.factories.HelpSectionFactory;
import java.lang.annotation.Annotation;

public class CommonSectionsFactory
implements HelpSectionFactory {
    @Override
    public HelpSection createSection(Annotation annotation) {
        if (annotation instanceof Examples) {
            Examples ex = (Examples)annotation;
            return new ExamplesSection(ex.examples(), ex.descriptions());
        }
        if (annotation instanceof Discussion) {
            return new DiscussionSection(((Discussion)annotation).paragraphs());
        }
        if (annotation instanceof ExitCodes) {
            ExitCodes exits = (ExitCodes)annotation;
            return new ExitCodesSection(exits.codes(), exits.descriptions());
        }
        if (annotation instanceof HideSection) {
            HideSection hide = (HideSection)annotation;
            return new BasicSection(hide.title(), 0, null, null, HelpFormat.NONE_PRINTABLE, (String[][])new String[][]{new String[0]});
        }
        return null;
    }
}

