/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.AbstractParser;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.aliases.AliasResolver;
import com.github.rvesse.airline.parser.errors.ParseTooManyArgumentsException;
import com.github.rvesse.airline.parser.options.OptionParser;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.parser.AbbreviatedCommandFinder;
import com.github.rvesse.airline.utils.predicates.parser.AbbreviatedGroupFinder;
import com.github.rvesse.airline.utils.predicates.parser.CommandFinder;
import com.github.rvesse.airline.utils.predicates.parser.GroupFinder;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.PeekingIterator;

public abstract class AbstractCommandParser<T>
extends AbstractParser<T> {
    protected ParseState<T> tryParse(GlobalMetadata<T> metadata, String ... args) {
        return this.tryParse(metadata, AirlineUtils.unmodifiableListCopy(args));
    }

    protected ParseState<T> tryParse(GlobalMetadata<T> metadata, Iterable<String> args) {
        PeekingIterator<String> tokens = new PeekingIterator<String>(args.iterator());
        ParseState state = ParseState.newInstance().pushContext(Context.GLOBAL).withGlobal(metadata);
        state = this.parseOptions(tokens, state, metadata.getOptions());
        tokens = this.applyAliases(tokens, state);
        state = this.parseGroup(tokens, state);
        state = this.parseCommand(tokens, state);
        return state;
    }

    protected PeekingIterator<String> applyAliases(PeekingIterator<String> tokens, ParseState<T> state) {
        AliasResolver<T> resolver = new AliasResolver<T>();
        return resolver.resolveAliases(tokens, state);
    }

    protected ParseState<T> tryParse(ParserMetadata<T> parserConfig, CommandMetadata command, Iterable<String> args) {
        PeekingIterator tokens = new PeekingIterator(args.iterator());
        ParseState state = ParseState.newInstance().pushContext(Context.GLOBAL).withConfiguration(parserConfig).withCommand(command).pushContext(Context.COMMAND);
        state = this.parseCommandOptionsAndArguments((PeekingIterator<String>)tokens, state, command);
        return state;
    }

    protected ParseState<T> parseCommand(PeekingIterator<String> tokens, ParseState<T> state) {
        List<CommandMetadata> expectedCommands = state.getGlobal().getDefaultGroupCommands();
        if (state.getGroup() != null) {
            expectedCommands = state.getGroup().getCommands();
        }
        if (tokens.hasNext()) {
            Object findCommandPredicate = state.getParserConfiguration().allowsAbbreviatedCommands() ? new AbbreviatedCommandFinder((String)tokens.peek(), (Collection<CommandMetadata>)expectedCommands) : new CommandFinder((String)tokens.peek());
            CommandMetadata command = AirlineUtils.find(expectedCommands, findCommandPredicate, state.getGroup() != null ? state.getGroup().getDefaultCommand() : null);
            boolean usingDefault = false;
            if (command == null && state.getGroup() == null && state.getGlobal().getDefaultCommand() != null) {
                usingDefault = true;
                command = state.getGlobal().getDefaultCommand();
            }
            if (command == null) {
                while (tokens.hasNext()) {
                    state = state.withUnparsedInput((String)tokens.next());
                }
            } else {
                if (((String)tokens.peek()).equals(command.getName()) || !usingDefault && state.getParserConfiguration().allowsAbbreviatedCommands()) {
                    tokens.next();
                }
                state = state.withCommand(command).pushContext(Context.COMMAND);
                state = this.parseCommandOptionsAndArguments(tokens, state, command);
            }
        }
        return state;
    }

    protected ParseState<T> parseCommandOptionsAndArguments(PeekingIterator<String> tokens, ParseState<T> state, CommandMetadata command) {
        while (tokens.hasNext()) {
            state = this.parseOptions(tokens, state, command.getCommandOptions());
            state = this.parseArgs(state, tokens, command.getArguments(), command.getDefaultOption());
        }
        return state;
    }

    protected ParseState<T> parseGroup(PeekingIterator<String> tokens, ParseState<T> state) {
        if (tokens.hasNext()) {
            Object findGroupPredicate = state.getParserConfiguration().allowsAbbreviatedCommands() ? new AbbreviatedGroupFinder((String)tokens.peek(), (Collection<CommandGroupMetadata>)state.getGlobal().getCommandGroups()) : new GroupFinder((String)tokens.peek());
            CommandGroupMetadata group = (CommandGroupMetadata)CollectionUtils.find(state.getGlobal().getCommandGroups(), (Predicate)findGroupPredicate);
            if (group != null) {
                tokens.next();
                state = state.withGroup(group).pushContext(Context.GROUP);
                state = this.parseOptions(tokens, state, state.getGroup().getOptions());
                while (tokens.hasNext() && state.getGroup().getSubGroups().size() > 0) {
                    Object object = findGroupPredicate = state.getParserConfiguration().allowsAbbreviatedCommands() ? new AbbreviatedGroupFinder((String)tokens.peek(), (Collection<CommandGroupMetadata>)state.getGroup().getSubGroups()) : new GroupFinder((String)tokens.peek());
                    group = (CommandGroupMetadata)CollectionUtils.find(state.getGroup().getSubGroups(), (Predicate)findGroupPredicate);
                    if (group == null) continue;
                    tokens.next();
                    state = state.withGroup(group).pushContext(Context.GROUP);
                    state = this.parseOptions(tokens, state, state.getGroup().getOptions());
                }
            }
        }
        return state;
    }

    private ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        List<OptionParser<T>> optionParsers = state.getParserConfiguration().getOptionParsers();
        while (tokens.hasNext()) {
            boolean matched = false;
            for (OptionParser<T> optionParser : optionParsers) {
                ParseState<T> nextState = optionParser.parseOptions(tokens, state, allowedOptions);
                if (nextState == null) continue;
                state = nextState;
                matched = true;
                break;
            }
            if (matched) continue;
        }
        return state;
    }

    private ParseState<T> parseArgs(ParseState<T> state, PeekingIterator<String> tokens, ArgumentsMetadata arguments, OptionMetadata defaultOption) {
        String sep = state.getParserConfiguration().getArgumentsSeparator();
        if (tokens.hasNext()) {
            if (((String)tokens.peek()).equals(sep)) {
                state = state.pushContext(Context.ARGS);
                tokens.next();
                while (tokens.hasNext()) {
                    state = this.parseArg(state, tokens, arguments, null);
                }
            } else {
                state = this.parseArg(state, tokens, arguments, defaultOption);
            }
        }
        return state;
    }

    private ParseState<T> parseArg(ParseState<T> state, PeekingIterator<String> tokens, ArgumentsMetadata arguments, OptionMetadata defaultOption) {
        if (arguments != null) {
            if (arguments.getArity() > 0 && state.getParsedArguments().size() == arguments.getArity()) {
                throw new ParseTooManyArgumentsException("Too many arguments, at most %d arguments are permitted but extra argument %s was encountered", arguments.getArity(), tokens.peek());
            }
            this.checkValidValue(state, arguments, (String)tokens.peek());
            state = state.withArgument(this.getTypeConverter(state).convert(arguments.getTitle().get(0), arguments.getJavaType(), (String)tokens.next()));
        } else if (defaultOption != null) {
            state = state.pushContext(Context.OPTION).withOption(defaultOption);
            String tokenStr = (String)tokens.next();
            this.checkValidValue(state, defaultOption, tokenStr);
            Object value = this.getTypeConverter(state).convert(defaultOption.getTitle(), defaultOption.getJavaType(), tokenStr);
            state = state.withOptionValue(defaultOption, value).popContext();
        } else {
            state = state.withUnparsedInput((String)tokens.next());
        }
        return state;
    }
}

