/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.command;

import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.AbstractCommandParser;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.ParserUtil;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.HashMap;

public class CliParser<T>
extends AbstractCommandParser<T> {
    public T parse(GlobalMetadata<T> metadata, Iterable<String> args) {
        if (args == null) {
            throw new NullPointerException("args cannot be null");
        }
        ParseState<T> state = this.tryParse(metadata, args);
        if (state.getCommand() == null) {
            state = state.getGroup() != null ? state.withCommand(state.getGroup().getDefaultCommand()) : state.withCommand(metadata.getDefaultCommand());
        }
        this.validate(state);
        CommandMetadata command = state.getCommand();
        HashMap<Class, Object> bindings = new HashMap<Class, Object>();
        bindings.put(GlobalMetadata.class, metadata);
        if (state.getGroup() != null) {
            bindings.put(CommandGroupMetadata.class, state.getGroup());
        }
        if (state.getCommand() != null) {
            bindings.put(CommandMetadata.class, state.getCommand());
        }
        bindings.put(ParserMetadata.class, state.getParserConfiguration());
        return ParserUtil.createInstance(command.getType(), command.getAllOptions(), state.getParsedOptions(), command.getArguments(), state.getParsedArguments(), command.getMetadataInjections(), AirlineUtils.unmodifiableMapCopy(bindings), state.getParserConfiguration().getCommandFactory());
    }

    protected void validate(ParseState<T> state) {
        for (GlobalRestriction restriction : state.getGlobal().getRestrictions()) {
            if (restriction == null) continue;
            restriction.validate(state);
        }
        CommandMetadata command = state.getCommand();
        if (command != null) {
            ArgumentsMetadata arguments = command.getArguments();
            if (arguments != null) {
                for (ArgumentsRestriction restriction : arguments.getRestrictions()) {
                    if (restriction == null) continue;
                    restriction.postValidate(state, arguments);
                }
            }
            for (OptionMetadata option : command.getAllOptions()) {
                if (option == null) continue;
                for (OptionRestriction restriction : option.getRestrictions()) {
                    if (restriction == null) continue;
                    restriction.postValidate(state, option);
                }
            }
        }
    }
}

