/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingValueException;
import com.github.rvesse.airline.parser.errors.ParseOptionUnexpectedException;
import com.github.rvesse.airline.parser.options.AbstractOptionParser;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.apache.commons.lang3.StringUtils;

public class ListValueOptionParser<T>
extends AbstractOptionParser<T> {
    private static final char DEFAULT_SEPARATOR = ',';
    private final char separator;

    public ListValueOptionParser() {
        this(',');
    }

    public ListValueOptionParser(char separator) {
        if (Character.isWhitespace(separator)) {
            throw new IllegalArgumentException("List separator character cannot be a whitespace character");
        }
        this.separator = separator;
    }

    protected final List<String> getValues(String list) {
        return AirlineUtils.arrayToList(StringUtils.split((String)list, (char)this.separator));
    }

    @Override
    public ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        String list;
        String name = (String)tokens.peek();
        boolean noSep = false;
        OptionMetadata option = this.findOption(state, allowedOptions, name);
        if (option == null) {
            if (this.hasShortNamePrefix(name) && name.length() > 2) {
                String shortName = name.substring(0, 2);
                option = this.findOption(state, allowedOptions, shortName);
                boolean bl = noSep = option != null;
            }
            if (!noSep) {
                return null;
            }
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        String string = list = noSep ? name.substring(2) : null;
        if (option.getArity() == 0) {
            state = state.withOptionValue(option, Boolean.TRUE).popContext();
        } else {
            List<String> listValues;
            if (list == null) {
                if (!tokens.hasNext()) {
                    return state;
                }
                list = (String)tokens.next();
            }
            if ((listValues = this.getValues(list)).size() < option.getArity()) {
                throw new ParseOptionMissingValueException("Too few option values received for option %s in list value '%s' (%d values expected)", option.getTitle(), option.getOptions().iterator().next(), list, option.getArity());
            }
            if (listValues.size() > option.getArity()) {
                throw new ParseOptionUnexpectedException("Too many option values received for option %s in list value '%s' (%d values expected)", option.getOptions().iterator().next(), list, option.getArity());
            }
            if (option.getArity() == 1) {
                this.checkValidValue(state, option, listValues.get(0));
                Object value = this.getTypeConverter(state).convert(option.getTitle(), option.getJavaType(), listValues.get(0));
                state = state.withOptionValue(option, value).popContext();
            } else {
                ArrayList<Object> values = new ArrayList<Object>();
                for (String value : listValues) {
                    this.checkValidValue(state, option, value);
                    values.add(this.getTypeConverter(state).convert(option.getTitle(), option.getJavaType(), value));
                }
                state = state.withOptionValue(option, AirlineUtils.unmodifiableListCopy(values)).popContext();
            }
        }
        return state;
    }
}

