/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.options.AbstractOptionParser;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.apache.commons.lang3.StringUtils;

public class MaybePairValueOptionParser<T>
extends AbstractOptionParser<T> {
    private static final char DEFAULT_SEPARATOR = '=';
    private final char separator;

    public MaybePairValueOptionParser() {
        this('=');
    }

    public MaybePairValueOptionParser(char separator) {
        if (Character.isWhitespace(separator)) {
            throw new IllegalArgumentException("Pair separator character cannot be a whitespace character");
        }
        this.separator = separator;
    }

    protected final List<String> getValues(String list) {
        return AirlineUtils.arrayToList(StringUtils.split((String)list, (String)new String(new char[]{this.separator}), (int)2));
    }

    @Override
    public ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        List<String> pairValues;
        String maybePair;
        String name = (String)tokens.peek();
        boolean noSep = false;
        OptionMetadata option = this.findOption(state, allowedOptions, name);
        if (option == null) {
            if (this.hasShortNamePrefix(name) && name.length() > 2) {
                String shortName = name.substring(0, 2);
                option = this.findOption(state, allowedOptions, shortName);
                boolean bl = noSep = option != null;
            }
            if (!noSep) {
                return null;
            }
        }
        if (option.getArity() != 2) {
            return null;
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        String string = maybePair = noSep ? name.substring(2) : null;
        if (maybePair == null) {
            if (!tokens.hasNext()) {
                return state;
            }
            maybePair = (String)tokens.next();
        }
        if ((pairValues = this.getValues(maybePair)).size() < 2) {
            if (!tokens.hasNext()) {
                return state;
            }
            String peekedToken = (String)tokens.peek();
            if (this.findOption(state, allowedOptions, peekedToken) != null) {
                return state;
            }
            pairValues.add((String)tokens.next());
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (String value : pairValues) {
            this.checkValidValue(state, option, value);
            values.add(this.getTypeConverter(state).convert(option.getTitle(), option.getJavaType(), value));
        }
        state = state.withOptionValue(option, AirlineUtils.unmodifiableListCopy(values)).popContext();
        return state;
    }
}

