/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.options.AbstractOptionParser;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.iterators.PeekingIterator;

public class StandardOptionParser<T>
extends AbstractOptionParser<T> {
    @Override
    public ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        OptionMetadata option = this.findOption(state, allowedOptions, (String)tokens.peek());
        if (option == null) {
            return null;
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        if (option.getArity() == 0) {
            state = state.withOptionValue(option, Boolean.TRUE).popContext();
        } else if (option.getArity() == 1) {
            if (tokens.hasNext()) {
                String tokenStr = (String)tokens.next();
                this.checkValidValue(state, option, tokenStr);
                Object value = this.getTypeConverter(state).convert(option.getTitle(), option.getJavaType(), tokenStr);
                state = state.withOptionValue(option, value).popContext();
            }
        } else {
            int count;
            ArrayList<Object> values = new ArrayList<Object>();
            boolean hasSeparator = false;
            boolean foundNextOption = false;
            String argsSeparator = state.getParserConfiguration().getArgumentsSeparator();
            for (count = 0; count < option.getArity() && tokens.hasNext() && !hasSeparator; ++count) {
                String peekedToken = (String)tokens.peek();
                hasSeparator = peekedToken.equals(argsSeparator);
                boolean bl = foundNextOption = this.findOption(state, allowedOptions, peekedToken) != null;
                if (hasSeparator || foundNextOption) break;
                String tokenStr = (String)tokens.next();
                this.checkValidValue(state, option, tokenStr);
                values.add(this.getTypeConverter(state).convert(option.getTitle(), option.getJavaType(), tokenStr));
            }
            if (count == option.getArity() || hasSeparator || foundNextOption) {
                state = state.withOptionValue(option, AirlineUtils.unmodifiableListCopy(values)).popContext();
            }
        }
        return state;
    }
}

