/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseArgumentsIllegalValueException;
import com.github.rvesse.airline.parser.errors.ParseOptionIllegalValueException;
import com.github.rvesse.airline.restrictions.common.AbstractAllowedValuesRestriction;
import com.github.rvesse.airline.utils.predicates.LocaleSensitiveStringFinder;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;

public class AllowedRawValuesRestriction
extends AbstractAllowedValuesRestriction {
    private final Locale locale;

    public AllowedRawValuesRestriction(boolean ignoreCase, Locale locale, String ... values) {
        super(ignoreCase);
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        this.locale = locale;
        for (String value : values) {
            if (ignoreCase) {
                value = value.toLowerCase(locale);
            }
            this.rawValues.add(value);
        }
    }

    @Override
    public <T> void preValidate(ParseState<T> state, OptionMetadata option, String value) {
        if (this.rawValues.isEmpty()) {
            return;
        }
        if (!CollectionUtils.exists((Iterable)this.rawValues, (Predicate)new LocaleSensitiveStringFinder(value, this.locale))) {
            throw new ParseOptionIllegalValueException(option.getTitle(), (Object)value, AllowedRawValuesRestriction.asObjects(this.rawValues));
        }
    }

    @Override
    public <T> void preValidate(ParseState<T> state, ArgumentsMetadata arguments, String value) {
        if (this.rawValues.isEmpty()) {
            return;
        }
        if (!CollectionUtils.exists((Iterable)this.rawValues, (Predicate)new LocaleSensitiveStringFinder(value, this.locale))) {
            String title = state.getParsedArguments().size() == 0 ? arguments.getTitle().get(0) : (state.getParsedArguments().size() < arguments.getTitle().size() ? arguments.getTitle().get(state.getParsedArguments().size()) : arguments.getTitle().get(arguments.getTitle().size() - 1));
            throw new ParseArgumentsIllegalValueException(title, (Object)value, AllowedRawValuesRestriction.asObjects(this.rawValues));
        }
    }
}

