/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.DefaultTypeConverter;
import com.github.rvesse.airline.TypeConverter;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseArgumentsIllegalValueException;
import com.github.rvesse.airline.parser.errors.ParseInvalidRestrictionException;
import com.github.rvesse.airline.parser.errors.ParseOptionIllegalValueException;
import com.github.rvesse.airline.restrictions.common.AbstractAllowedValuesRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.parser.ParsedOptionFinder;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.tuple.Pair;

public class AllowedValuesRestriction
extends AbstractAllowedValuesRestriction {
    public AllowedValuesRestriction(String ... rawValues) {
        super(false);
        this.rawValues.addAll(AirlineUtils.arrayToList(rawValues));
    }

    @Override
    public <T> void postValidate(ParseState<T> state, OptionMetadata option) {
        if (this.rawValues.isEmpty()) {
            return;
        }
        Collection parsedOptions = CollectionUtils.select(state.getParsedOptions(), (Predicate)new ParsedOptionFinder(option));
        if (parsedOptions.isEmpty()) {
            return;
        }
        Set<Object> allowedValues = this.createAllowedValues(state, option.getTitle(), option.getJavaType());
        for (Pair parsedOption : parsedOptions) {
            if (allowedValues.contains(parsedOption.getRight())) continue;
            throw new ParseOptionIllegalValueException(option.getTitle(), parsedOption.getRight(), allowedValues);
        }
    }

    protected <T> Set<Object> createAllowedValues(ParseState<T> state, String title, Class<?> type) {
        LinkedHashSet<Object> actualValues = new LinkedHashSet<Object>();
        TypeConverter converter = state.getParserConfiguration().getTypeConverter();
        if (converter == null) {
            converter = new DefaultTypeConverter();
        }
        for (String rawValue : this.rawValues) {
            try {
                actualValues.add(converter.convert(title, type, rawValue));
            }
            catch (Exception e) {
                throw new ParseInvalidRestrictionException(e, "Unable to parse raw value '%s' in order to apply allowed values restriction", rawValue);
            }
        }
        return actualValues;
    }

    @Override
    public <T> void postValidate(ParseState<T> state, ArgumentsMetadata arguments) {
        if (this.rawValues.isEmpty()) {
            return;
        }
        List<Object> parsedArguments = state.getParsedArguments();
        if (parsedArguments.isEmpty()) {
            return;
        }
        Set<Object> allowedValues = this.createAllowedValues(state, arguments.getTitle().get(0), arguments.getJavaType());
        for (Object parsedArg : parsedArguments) {
            if (allowedValues.contains(parsedArg)) continue;
            throw new ParseArgumentsIllegalValueException(arguments.getTitle().get(0), parsedArg, allowedValues);
        }
    }
}

