/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.common.AbstractStringRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;

public class LengthRestriction
extends AbstractStringRestriction
implements HelpHint {
    private final boolean maximum;
    private final int length;

    public LengthRestriction(int length, boolean maximum) {
        this.length = length;
        this.maximum = maximum;
    }

    @Override
    protected boolean isValid(String value) {
        if (this.maximum) {
            return value.length() <= this.length;
        }
        return value.length() > this.length;
    }

    @Override
    protected <T> ParseRestrictionViolatedException violated(ParseState<T> state, OptionMetadata option, String value) {
        if (this.maximum) {
            return new ParseRestrictionViolatedException("Option '%s' was given value '%s' that has length %d which exceeds the maximum permitted length of %d", option.getTitle(), value, value.length(), this.length);
        }
        return new ParseRestrictionViolatedException("Option '%s' was given value '%s' that has length %d which is below the minimum required length of %d", option.getTitle(), value, value.length(), this.length);
    }

    @Override
    protected <T> ParseRestrictionViolatedException violated(ParseState<T> state, ArgumentsMetadata arguments, String value) {
        if (this.maximum) {
            return new ParseRestrictionViolatedException("Argument '%s' was given value '%s' that has length %d which exceeds the maximum permitted length of %d", AirlineUtils.first(arguments.getTitle()), value, value.length(), this.length);
        }
        return new ParseRestrictionViolatedException("Argument '%s' was given value '%s' that has length %d which is below the minimum required length of %d", AirlineUtils.first(arguments.getTitle()), value, value.length(), this.length);
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.maximum) {
            return new String[]{String.format("This options value has a maximum length of %d characters", this.length)};
        }
        return new String[]{String.format("This options value has a minimum length of %d characters", this.length)};
    }
}

