/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.common.AbstractStringRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import org.apache.commons.lang3.StringUtils;

public class NotEmptyRestriction
extends AbstractStringRestriction
implements HelpHint {
    @Override
    protected boolean isValid(String value) {
        return !StringUtils.isEmpty((CharSequence)value);
    }

    @Override
    protected <T> ParseRestrictionViolatedException violated(ParseState<T> state, OptionMetadata option, String value) {
        return new ParseRestrictionViolatedException("Option '%s' requires a non-empty value", option.getTitle());
    }

    @Override
    protected <T> ParseRestrictionViolatedException violated(ParseState<T> state, ArgumentsMetadata arguments, String value) {
        return new ParseRestrictionViolatedException("Arguments '%s' requires a non-empty value", AirlineUtils.first(arguments.getTitle()));
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String[]{"This options value cannot be empty"};
    }
}

