/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.annotations.restrictions.PortType;
import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseInvalidRestrictionException;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.parser.ParsedOptionFinder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.tuple.Pair;

public class PortRestriction
extends AbstractCommonRestriction
implements HelpHint {
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private Set<PortType> acceptablePorts = new HashSet<PortType>();

    public PortRestriction(PortType ... portTypes) {
        this.acceptablePorts.addAll(AirlineUtils.arrayToList(portTypes));
    }

    @Override
    public <T> void postValidate(ParseState<T> state, OptionMetadata option) {
        if (this.acceptablePorts.isEmpty()) {
            return;
        }
        Collection parsedOptions = CollectionUtils.select(state.getParsedOptions(), (Predicate)new ParsedOptionFinder(option));
        if (parsedOptions.isEmpty()) {
            return;
        }
        for (Pair parsedOption : parsedOptions) {
            Object value = parsedOption.getRight();
            if (value instanceof Long) {
                if (this.isValid((Long)value)) continue;
                this.invalidOptionPort(option, value);
                continue;
            }
            if (value instanceof Integer) {
                if (this.isValid((Integer)value)) continue;
                this.invalidOptionPort(option, value);
                continue;
            }
            if (value instanceof Short) {
                if (this.isValid((Short)value)) continue;
                this.invalidOptionPort(option, value);
                continue;
            }
            throw new ParseInvalidRestrictionException("Cannot apply a @Port restriction to an option of type %s", option.getJavaType());
        }
    }

    protected void invalidOptionPort(OptionMetadata option, Object value) {
        this.invalidPort(String.format("Option '%s'", option.getTitle()), value);
    }

    protected void invalidArgumentsPort(ArgumentsMetadata arguments, Object value) {
        this.invalidPort(String.format("Argument '%s'", arguments.getTitle().get(0)), value);
    }

    protected void invalidPort(String title, Object value) {
        throw new ParseRestrictionViolatedException("%s which takes a port number was given a value '%s' which not in the range of acceptable ports: %s", title, value, PortType.toRangesString(this.acceptablePorts));
    }

    @Override
    public <T> void postValidate(ParseState<T> state, ArgumentsMetadata arguments) {
        if (this.acceptablePorts.isEmpty()) {
            return;
        }
        if (state.getParsedArguments().isEmpty()) {
            return;
        }
        List<Object> values = state.getParsedArguments();
        Iterator<Object> i$ = values.iterator();
        if (i$.hasNext()) {
            Object value = i$.next();
            if (value instanceof Long) {
                if (!this.isValid((Long)value)) {
                    this.invalidArgumentsPort(arguments, value);
                }
            } else if (value instanceof Integer) {
                if (!this.isValid((Integer)value)) {
                    this.invalidArgumentsPort(arguments, value);
                }
            } else if (value instanceof Short && !this.isValid((Short)value)) {
                this.invalidArgumentsPort(arguments, value);
            }
            throw new ParseInvalidRestrictionException("Cannot apply a @Port restriction to an option of type %s", arguments.getJavaType());
        }
    }

    private boolean isValid(long port) {
        if (port < 0L || port > 65535L) {
            return false;
        }
        if (this.acceptablePorts.contains((Object)PortType.ANY)) {
            return true;
        }
        return this.inAnyAcceptableRange((int)port);
    }

    private boolean isValid(int port) {
        if (port < 0 || port > 65535) {
            return false;
        }
        if (this.acceptablePorts.contains((Object)PortType.ANY)) {
            return true;
        }
        return this.inAnyAcceptableRange(port);
    }

    private boolean isValid(short port) {
        if (port < 0 || port > 65535) {
            return false;
        }
        if (this.acceptablePorts.contains((Object)PortType.ANY)) {
            return true;
        }
        return this.inAnyAcceptableRange(port);
    }

    protected boolean inAnyAcceptableRange(int port) {
        for (PortType portType : this.acceptablePorts) {
            if (!portType.inRange(port)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.acceptablePorts.contains((Object)PortType.ANY)) {
            return new String[]{String.format("This options value represents a port and must fall in the port range %s", PortType.ANY.toString())};
        }
        return new String[]{String.format("This options value represents a port and must fall in one of the following port ranges: %s", PortType.toRangesString(this.acceptablePorts))};
    }
}

