/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseInvalidRestrictionException;
import com.github.rvesse.airline.parser.errors.ParseOptionOutOfRangeException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.parser.ParsedOptionFinder;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.tuple.Pair;

public class RangeRestriction
extends AbstractCommonRestriction
implements HelpHint {
    private final Object min;
    private final Object max;
    private final boolean minInclusive;
    private final boolean maxInclusive;
    private final Comparator<Object> comparator;

    public RangeRestriction(Object min, boolean minInclusive, Object max, boolean maxInclusive, Comparator<Object> comparator) {
        if (comparator == null) {
            throw new ParseInvalidRestrictionException("comparator cannot be null", new Object[0]);
        }
        this.min = min;
        this.minInclusive = minInclusive;
        this.max = max;
        this.maxInclusive = maxInclusive;
        this.comparator = comparator;
        if (min != null && max != null) {
            int rangeComparison = this.comparator.compare(min, max);
            if (rangeComparison > 0) {
                throw new ParseInvalidRestrictionException("min (%s) is greater than max (%s)", min, max);
            }
            if (!(rangeComparison != 0 || minInclusive && maxInclusive)) {
                throw new ParseInvalidRestrictionException("min (%s) and max (%s) compare as equal but either minInclusive or maxInclusive was false", min, max);
            }
        }
    }

    @Override
    public <T> void postValidate(ParseState<T> state, OptionMetadata option) {
        if (this.min == null && this.max == null) {
            return;
        }
        Collection parsedOptions = CollectionUtils.select(state.getParsedOptions(), (Predicate)new ParsedOptionFinder(option));
        if (parsedOptions.isEmpty()) {
            return;
        }
        for (Pair parsedOption : parsedOptions) {
            if (this.inRange(parsedOption.getRight())) continue;
            throw new ParseOptionOutOfRangeException(option.getTitle(), parsedOption.getRight(), this.min, this.minInclusive, this.max, this.maxInclusive);
        }
    }

    protected boolean inRange(Object value) {
        if (this.min != null) {
            int minComparison = this.comparator.compare(this.min, value);
            if (minComparison == 0) {
                return this.minInclusive;
            }
            if (minComparison > 0) {
                return false;
            }
        }
        if (this.max != null) {
            int maxComparison = this.comparator.compare(value, this.max);
            if (maxComparison == 0) {
                return this.maxInclusive;
            }
            if (maxComparison > 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String[]{String.format("This options value must fall in the following range: %s", AirlineUtils.toRangeString(this.min, this.minInclusive, this.max, this.maxInclusive))};
    }
}

