/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.factories;

import com.github.rvesse.airline.annotations.restrictions.AllowedRawValues;
import com.github.rvesse.airline.annotations.restrictions.AllowedValues;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.AllowedRawValuesRestriction;
import com.github.rvesse.airline.restrictions.common.AllowedValuesRestriction;
import com.github.rvesse.airline.restrictions.factories.ArgumentsRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.OptionRestrictionFactory;
import java.lang.annotation.Annotation;
import java.util.Locale;

public class AllowedValuesRestrictionFactory
implements OptionRestrictionFactory,
ArgumentsRestrictionFactory {
    @Override
    public OptionRestriction createOptionRestriction(Annotation annotation) {
        return (OptionRestriction)this.createCommon(annotation);
    }

    protected Object createCommon(Annotation annotation) {
        if (annotation instanceof AllowedRawValues) {
            AllowedRawValues allowedValues = (AllowedRawValues)annotation;
            return new AllowedRawValuesRestriction(allowedValues.ignoreCase(), Locale.forLanguageTag(allowedValues.locale()), allowedValues.allowedValues());
        }
        if (annotation instanceof AllowedValues) {
            AllowedValues allowedValues = (AllowedValues)annotation;
            return new AllowedValuesRestriction(allowedValues.allowedValues());
        }
        return null;
    }

    @Override
    public ArgumentsRestriction createArgumentsRestriction(Annotation annotation) {
        return (ArgumentsRestriction)this.createCommon(annotation);
    }
}

