/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.factories;

import com.github.rvesse.airline.annotations.restrictions.ranges.ByteRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.DoubleRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.FloatRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.IntegerRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.LexicalRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.LongRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.ShortRange;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.RangeRestriction;
import com.github.rvesse.airline.restrictions.factories.ArgumentsRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.OptionRestrictionFactory;
import com.github.rvesse.airline.utils.comparators.ByteComparator;
import com.github.rvesse.airline.utils.comparators.DoubleComparator;
import com.github.rvesse.airline.utils.comparators.FloatComparator;
import com.github.rvesse.airline.utils.comparators.IntegerComparator;
import com.github.rvesse.airline.utils.comparators.LexicalComparator;
import com.github.rvesse.airline.utils.comparators.LongComparator;
import com.github.rvesse.airline.utils.comparators.ShortComparator;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class RangeRestrictionFactory
implements OptionRestrictionFactory,
ArgumentsRestrictionFactory {
    private static final Comparator<Object> LONG_COMPARATOR = new LongComparator();
    private static final Comparator<Object> INTEGER_COMPARATOR = new IntegerComparator();
    private static final Comparator<Object> SHORT_COMPARATOR = new ShortComparator();
    private static final Comparator<Object> BYTE_COMPARATOR = new ByteComparator();
    private static final Comparator<Object> DOUBLE_COMPARATOR = new DoubleComparator();
    private static final Comparator<Object> FLOAT_COMPARATOR = new FloatComparator();

    @Override
    public final OptionRestriction createOptionRestriction(Annotation annotation) {
        return this.createCommon(annotation);
    }

    @Override
    public final ArgumentsRestriction createArgumentsRestriction(Annotation annotation) {
        return this.createCommon(annotation);
    }

    protected final RangeRestriction createCommon(Annotation annotation) {
        if (annotation instanceof LongRange) {
            return this.createLongRange(annotation);
        }
        if (annotation instanceof IntegerRange) {
            return this.createIntegerRange(annotation);
        }
        if (annotation instanceof ShortRange) {
            return this.createShortRange(annotation);
        }
        if (annotation instanceof ByteRange) {
            return this.createByteRange(annotation);
        }
        if (annotation instanceof DoubleRange) {
            return this.createDoubleRange(annotation);
        }
        if (annotation instanceof FloatRange) {
            return this.createFloatRange(annotation);
        }
        if (annotation instanceof LexicalRange) {
            return this.createLexicalRange(annotation);
        }
        return this.createUnknownRange(annotation);
    }

    protected RangeRestriction createUnknownRange(Annotation annotation) {
        return null;
    }

    protected RangeRestriction createLexicalRange(Annotation annotation) {
        LexicalRange lRange = (LexicalRange)annotation;
        return new RangeRestriction(StringUtils.isEmpty((CharSequence)lRange.min()) ? null : lRange.min(), lRange.minInclusive(), StringUtils.isEmpty((CharSequence)lRange.max()) ? null : lRange.max(), lRange.maxInclusive(), new LexicalComparator(Locale.forLanguageTag(lRange.locale())));
    }

    protected RangeRestriction createFloatRange(Annotation annotation) {
        FloatRange sRange = (FloatRange)annotation;
        return new RangeRestriction(Float.valueOf(sRange.min()), sRange.minInclusive(), Float.valueOf(sRange.max()), sRange.maxInclusive(), FLOAT_COMPARATOR);
    }

    protected RangeRestriction createDoubleRange(Annotation annotation) {
        DoubleRange sRange = (DoubleRange)annotation;
        return new RangeRestriction(sRange.min(), sRange.minInclusive(), sRange.max(), sRange.maxInclusive(), DOUBLE_COMPARATOR);
    }

    protected RangeRestriction createByteRange(Annotation annotation) {
        ByteRange sRange = (ByteRange)annotation;
        return new RangeRestriction(sRange.min(), sRange.minInclusive(), sRange.max(), sRange.maxInclusive(), BYTE_COMPARATOR);
    }

    protected RangeRestriction createShortRange(Annotation annotation) {
        ShortRange sRange = (ShortRange)annotation;
        return new RangeRestriction(sRange.min(), sRange.minInclusive(), sRange.max(), sRange.maxInclusive(), SHORT_COMPARATOR);
    }

    protected RangeRestriction createIntegerRange(Annotation annotation) {
        IntegerRange iRange = (IntegerRange)annotation;
        return new RangeRestriction(iRange.min(), iRange.minInclusive(), iRange.max(), iRange.maxInclusive(), INTEGER_COMPARATOR);
    }

    protected RangeRestriction createLongRange(Annotation annotation) {
        LongRange iRange = (LongRange)annotation;
        return new RangeRestriction(iRange.min(), iRange.minInclusive(), iRange.max(), iRange.maxInclusive(), LONG_COMPARATOR);
    }
}

