/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.factories;

import com.github.rvesse.airline.annotations.restrictions.AllowedRawValues;
import com.github.rvesse.airline.annotations.restrictions.MaxLength;
import com.github.rvesse.airline.annotations.restrictions.MaxOccurrences;
import com.github.rvesse.airline.annotations.restrictions.MinLength;
import com.github.rvesse.airline.annotations.restrictions.MinOccurrences;
import com.github.rvesse.airline.annotations.restrictions.NotBlank;
import com.github.rvesse.airline.annotations.restrictions.NotEmpty;
import com.github.rvesse.airline.annotations.restrictions.Once;
import com.github.rvesse.airline.annotations.restrictions.Pattern;
import com.github.rvesse.airline.annotations.restrictions.Port;
import com.github.rvesse.airline.annotations.restrictions.RequireOnlyOne;
import com.github.rvesse.airline.annotations.restrictions.RequireSome;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.github.rvesse.airline.annotations.restrictions.RequiredOnlyIf;
import com.github.rvesse.airline.annotations.restrictions.Unrestricted;
import com.github.rvesse.airline.annotations.restrictions.ranges.ByteRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.DoubleRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.FloatRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.IntegerRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.LexicalRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.LongRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.ShortRange;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.None;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.IsRequiredRestriction;
import com.github.rvesse.airline.restrictions.factories.AllowedValuesRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.ArgumentsRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.OccurrencesRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.OptionRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.PortRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.RangeRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.RequireFromRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.RequiredOnlyIfRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.SimpleArgumentsRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.SimpleOptionRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.StringRestrictionFactory;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RestrictionRegistry {
    private static final Map<Class<? extends Annotation>, OptionRestrictionFactory> OPTION_RESTRICTION_FACTORIES = new HashMap<Class<? extends Annotation>, OptionRestrictionFactory>();
    private static final Map<Class<? extends Annotation>, ArgumentsRestrictionFactory> ARGUMENT_RESTRICTION_FACTORIES = new HashMap<Class<? extends Annotation>, ArgumentsRestrictionFactory>();
    private static volatile boolean init = false;

    private static <T extends OptionRestrictionFactory & ArgumentsRestrictionFactory> void registerCommon(Class<? extends Annotation> cls, T factory) {
        RestrictionRegistry.registerCommon(cls, factory, factory);
    }

    private static void registerCommon(Class<? extends Annotation> cls, OptionRestrictionFactory opFactory, ArgumentsRestrictionFactory argFactory) {
        OPTION_RESTRICTION_FACTORIES.put(cls, opFactory);
        ARGUMENT_RESTRICTION_FACTORIES.put(cls, argFactory);
    }

    static synchronized void init() {
        if (init) {
            return;
        }
        RestrictionRegistry.registerCommon(Required.class, new SimpleOptionRestrictionFactory(IsRequiredRestriction.class), new SimpleArgumentsRestrictionFactory(IsRequiredRestriction.class));
        RestrictionRegistry.registerCommon(Unrestricted.class, new SimpleOptionRestrictionFactory(None.class), new SimpleArgumentsRestrictionFactory(None.class));
        AllowedValuesRestrictionFactory allowedFactory = new AllowedValuesRestrictionFactory();
        RestrictionRegistry.registerCommon(AllowedRawValues.class, allowedFactory, allowedFactory);
        RangeRestrictionFactory rangeFactory = new RangeRestrictionFactory();
        RestrictionRegistry.registerCommon(LongRange.class, rangeFactory);
        RestrictionRegistry.registerCommon(IntegerRange.class, rangeFactory);
        RestrictionRegistry.registerCommon(ShortRange.class, rangeFactory);
        RestrictionRegistry.registerCommon(ByteRange.class, rangeFactory);
        RestrictionRegistry.registerCommon(DoubleRange.class, rangeFactory);
        RestrictionRegistry.registerCommon(FloatRange.class, rangeFactory);
        RestrictionRegistry.registerCommon(LexicalRange.class, rangeFactory);
        RequireFromRestrictionFactory requireFactory = new RequireFromRestrictionFactory();
        OPTION_RESTRICTION_FACTORIES.put(RequireOnlyOne.class, requireFactory);
        OPTION_RESTRICTION_FACTORIES.put(RequireSome.class, requireFactory);
        OPTION_RESTRICTION_FACTORIES.put(RequiredOnlyIf.class, new RequiredOnlyIfRestrictionFactory());
        OccurrencesRestrictionFactory occurrenceFactory = new OccurrencesRestrictionFactory();
        RestrictionRegistry.registerCommon(Once.class, occurrenceFactory);
        RestrictionRegistry.registerCommon(MaxOccurrences.class, occurrenceFactory);
        RestrictionRegistry.registerCommon(MinOccurrences.class, occurrenceFactory);
        StringRestrictionFactory stringFactory = new StringRestrictionFactory();
        RestrictionRegistry.registerCommon(Pattern.class, stringFactory);
        RestrictionRegistry.registerCommon(MaxLength.class, stringFactory);
        RestrictionRegistry.registerCommon(MinLength.class, stringFactory);
        RestrictionRegistry.registerCommon(NotEmpty.class, stringFactory);
        RestrictionRegistry.registerCommon(NotBlank.class, stringFactory);
        RestrictionRegistry.registerCommon(Port.class, new PortRestrictionFactory());
        init = true;
    }

    public static synchronized void reset() {
        init = false;
        OPTION_RESTRICTION_FACTORIES.clear();
        ARGUMENT_RESTRICTION_FACTORIES.clear();
        RestrictionRegistry.init();
    }

    public static Set<Class<? extends Annotation>> getOptionRestrictionAnnotationClasses() {
        return OPTION_RESTRICTION_FACTORIES.keySet();
    }

    public static void addOptionRestriction(Class<? extends Annotation> cls, OptionRestrictionFactory factory) {
        if (cls == null) {
            throw new NullPointerException("cls cannot be null");
        }
        OPTION_RESTRICTION_FACTORIES.put(cls, factory);
    }

    public static <T extends Annotation> OptionRestriction getOptionRestriction(Class<? extends Annotation> cls, T annotation) {
        OptionRestrictionFactory factory = OPTION_RESTRICTION_FACTORIES.get(cls);
        if (factory != null) {
            return factory.createOptionRestriction(annotation);
        }
        return null;
    }

    public static void addArgumentsRestriction(Class<? extends Annotation> cls, ArgumentsRestrictionFactory factory) {
        if (cls == null) {
            throw new NullPointerException("cls cannot be null");
        }
        ARGUMENT_RESTRICTION_FACTORIES.put(cls, factory);
    }

    public static Set<Class<? extends Annotation>> getArgumentsRestrictionAnnotationClasses() {
        return ARGUMENT_RESTRICTION_FACTORIES.keySet();
    }

    public static <T extends Annotation> ArgumentsRestriction getArgumentsRestriction(Class<? extends Annotation> cls, T annotation) {
        ArgumentsRestrictionFactory factory = ARGUMENT_RESTRICTION_FACTORIES.get(cls);
        if (factory != null) {
            return factory.createArgumentsRestriction(annotation);
        }
        return null;
    }

    static {
        RestrictionRegistry.init();
    }
}

