/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.builder;

import com.github.rvesse.airline.CommandFactory;
import com.github.rvesse.airline.DefaultCommandFactory;
import com.github.rvesse.airline.DefaultTypeConverter;
import com.github.rvesse.airline.TypeConverter;
import com.github.rvesse.airline.builder.AbstractBuilder;
import com.github.rvesse.airline.builder.AliasBuilder;
import com.github.rvesse.airline.model.AliasMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.aliases.UserAliasesSource;
import com.github.rvesse.airline.parser.options.ClassicGetOptParser;
import com.github.rvesse.airline.parser.options.LongGetOptParser;
import com.github.rvesse.airline.parser.options.OptionParser;
import com.github.rvesse.airline.parser.options.StandardOptionParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParserBuilder<C>
extends AbstractBuilder<ParserMetadata<C>> {
    protected TypeConverter typeConverter = new DefaultTypeConverter();
    protected final Map<String, AliasBuilder<C>> aliases = new HashMap<String, AliasBuilder<C>>();
    protected CommandFactory<C> commandFactory = new DefaultCommandFactory<C>();
    protected boolean allowAbbreviatedCommands;
    protected boolean allowAbbreviatedOptions;
    protected boolean aliasesOverrideBuiltIns;
    protected boolean aliasesMayChain;
    protected final List<OptionParser<C>> optionParsers = new ArrayList<OptionParser<C>>();
    protected String argsSeparator;
    protected UserAliasesSource<C> userAliases;

    public static <T> ParserMetadata<T> defaultConfiguration() {
        return new ParserBuilder().build();
    }

    public ParserBuilder<C> withCommandFactory(CommandFactory<C> commandFactory) {
        this.commandFactory = commandFactory;
        return this;
    }

    public ParserBuilder<C> withDefaultCommandFactory() {
        this.commandFactory = null;
        return this;
    }

    public AliasBuilder<C> withAlias(String name) {
        this.checkNotBlank(name, "Alias name");
        if (this.aliases.containsKey(name)) {
            return this.aliases.get(name);
        }
        AliasBuilder alias = new AliasBuilder(name);
        this.aliases.put(name, alias);
        return alias;
    }

    public AliasBuilder<C> getAlias(String name) {
        this.checkNotBlank(name, "Alias name");
        if (!this.aliases.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Alias %s has not been declared", name));
        }
        return this.aliases.get(name);
    }

    public ParserBuilder<C> withUserAliases(String programName) {
        return this.withUserAliases(programName + ".config", null, System.getProperty("user.home") + "/." + programName + "/");
    }

    public ParserBuilder<C> withUserAliases(String programName, String searchLocation) {
        return this.withUserAliases(programName + ".config", null, searchLocation);
    }

    public ParserBuilder<C> withUserAliases(String filename, String prefix, String ... searchLocations) {
        this.userAliases = new UserAliasesSource(filename, prefix, searchLocations);
        return this;
    }

    public ParserBuilder<C> withAliasesOverridingBuiltIns() {
        this.aliasesOverrideBuiltIns = true;
        return this;
    }

    public ParserBuilder<C> withAliasesChaining() {
        this.aliasesMayChain = true;
        return this;
    }

    public ParserBuilder<C> withCommandAbbreviation() {
        this.allowAbbreviatedCommands = true;
        return this;
    }

    public ParserBuilder<C> withOptionAbbreviation() {
        this.allowAbbreviatedOptions = true;
        return this;
    }

    public ParserBuilder<C> withTypeConverter(TypeConverter converter) {
        this.typeConverter = converter;
        return this;
    }

    public ParserBuilder<C> withDefaultTypeConverter() {
        this.typeConverter = null;
        return this;
    }

    public ParserBuilder<C> withOptionParser(OptionParser<C> optionParser) {
        if (optionParser != null) {
            this.optionParsers.add(optionParser);
        }
        return this;
    }

    public ParserBuilder<C> withOptionParsers(OptionParser<C> ... optionParsers) {
        if (optionParsers != null) {
            for (OptionParser<C> parser : optionParsers) {
                if (parser == null) continue;
                this.optionParsers.add(parser);
            }
        }
        return this;
    }

    public ParserBuilder<C> withOnlyDefaultOptionParsers() {
        this.optionParsers.clear();
        return this.withDefaultOptionParsers();
    }

    public ParserBuilder<C> withDefaultOptionParsers() {
        return this.withOptionParsers(new StandardOptionParser(), new LongGetOptParser(), new ClassicGetOptParser());
    }

    public ParserBuilder<C> withArgumentsSeparator(String separator) {
        this.argsSeparator = separator;
        return this;
    }

    @Override
    public ParserMetadata<C> build() {
        ArrayList<AliasMetadata> aliasData;
        if (this.optionParsers.size() == 0) {
            this.withDefaultOptionParsers();
        }
        if (this.userAliases != null) {
            try {
                for (AliasMetadata alias : this.userAliases.load()) {
                    this.aliases.put(alias.getName(), new AliasBuilder(alias.getName()).withArguments(alias.getArguments().toArray(new String[alias.getArguments().size()])));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load user aliases", e);
            }
        }
        if (this.aliases != null) {
            aliasData = new ArrayList<AliasMetadata>();
            for (AliasBuilder<C> aliasBuilder : this.aliases.values()) {
                aliasData.add(aliasBuilder.build());
            }
        } else {
            aliasData = new ArrayList();
        }
        return new ParserMetadata<C>(this.commandFactory, this.optionParsers, this.typeConverter, this.allowAbbreviatedCommands, this.allowAbbreviatedOptions, aliasData, this.userAliases, this.aliasesOverrideBuiltIns, this.aliasesMayChain, this.argsSeparator);
    }
}

