/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.model;

import com.github.rvesse.airline.CommandFactory;
import com.github.rvesse.airline.DefaultCommandFactory;
import com.github.rvesse.airline.DefaultTypeConverter;
import com.github.rvesse.airline.TypeConverter;
import com.github.rvesse.airline.model.AliasMetadata;
import com.github.rvesse.airline.parser.aliases.UserAliasesSource;
import com.github.rvesse.airline.parser.options.OptionParser;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ParserMetadata<T> {
    public static final String DEFAULT_ARGUMENTS_SEPARATOR = "--";
    private final boolean allowAbbreviatedCommands;
    private final boolean allowAbbreviatedOptions;
    private final boolean aliasesOverrideBuiltIns;
    private final boolean aliasesMayChain;
    private final List<OptionParser<T>> optionParsers;
    private final List<AliasMetadata> aliases;
    private final UserAliasesSource<T> userAliases;
    private final TypeConverter typeConverter;
    private final CommandFactory<T> commandFactory;
    private final String argsSeparator;

    public ParserMetadata(CommandFactory<T> commandFactory, List<OptionParser<T>> optionParsers, TypeConverter typeConverter, boolean allowAbbreviateCommands, boolean allowAbbreviatedOptions, List<AliasMetadata> aliases, UserAliasesSource<T> userAliases, boolean aliasesOverrideBuiltIns, boolean aliasesMayChain, String argumentsSeparator) {
        if (optionParsers == null) {
            throw new NullPointerException("optionParsers cannot be null");
        }
        if (aliases == null) {
            throw new NullPointerException("aliases cannot be null");
        }
        this.commandFactory = commandFactory != null ? commandFactory : new DefaultCommandFactory();
        this.allowAbbreviatedCommands = allowAbbreviateCommands;
        this.typeConverter = typeConverter != null ? typeConverter : new DefaultTypeConverter();
        this.optionParsers = AirlineUtils.unmodifiableListCopy(optionParsers);
        this.allowAbbreviatedOptions = allowAbbreviatedOptions;
        this.aliases = AirlineUtils.unmodifiableListCopy(aliases);
        this.userAliases = userAliases;
        this.aliasesOverrideBuiltIns = aliasesOverrideBuiltIns;
        this.aliasesMayChain = aliasesMayChain;
        if (StringUtils.isNotEmpty((CharSequence)argumentsSeparator) && StringUtils.containsWhitespace((CharSequence)argumentsSeparator)) {
            throw new IllegalArgumentException("argumentsSeparator cannot contain any whitespace");
        }
        this.argsSeparator = StringUtils.isNotEmpty((CharSequence)argumentsSeparator) ? argumentsSeparator : DEFAULT_ARGUMENTS_SEPARATOR;
    }

    public CommandFactory<T> getCommandFactory() {
        return this.commandFactory;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public List<AliasMetadata> getAliases() {
        return this.aliases;
    }

    public UserAliasesSource<T> getUserAliasesSource() {
        return this.userAliases;
    }

    public boolean aliasesOverrideBuiltIns() {
        return this.aliasesOverrideBuiltIns;
    }

    public boolean aliasesMayChain() {
        return this.aliasesMayChain;
    }

    public List<OptionParser<T>> getOptionParsers() {
        return this.optionParsers;
    }

    public boolean allowsAbbreviatedCommands() {
        return this.allowAbbreviatedCommands;
    }

    public boolean allowsAbbreviatedOptions() {
        return this.allowAbbreviatedOptions;
    }

    public String getArgumentsSeparator() {
        return this.argsSeparator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParserMetadata {");
        sb.append("commandFactory=").append(this.commandFactory.getClass().getCanonicalName());
        sb.append(", allowAbbreviatedCommands=").append(this.allowAbbreviatedCommands);
        sb.append(", optionParsers=").append(this.optionParsers);
        sb.append(", typeConverter=").append(this.typeConverter.getClass().getCanonicalName());
        sb.append(", allowAbbreviatedOptions=").append(this.allowAbbreviatedOptions);
        sb.append(", aliases=").append(this.aliases);
        sb.append(", aliasesOverrideBuiltIns=").append(this.aliasesOverrideBuiltIns);
        sb.append(", argumentsSeparator='").append(this.argsSeparator).append("'");
        sb.append("}");
        return sb.toString();
    }
}

