/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.command;

import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.AbstractCommandParser;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.ParserUtil;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;

public class SingleCommandParser<T>
extends AbstractCommandParser<T> {
    public T parse(ParserMetadata<T> parserConfig, CommandMetadata commandMetadata, Iterable<GlobalRestriction> restrictions, Iterable<String> args) {
        if (args == null) {
            throw new NullPointerException("args is null");
        }
        ParseState<T> state = this.tryParse(parserConfig, commandMetadata, args);
        this.validate(state, IteratorUtils.toList(restrictions.iterator()));
        CommandMetadata command = state.getCommand();
        return ParserUtil.createInstance(command.getType(), command.getAllOptions(), state.getParsedOptions(), command.getArguments(), state.getParsedArguments(), command.getMetadataInjections(), Collections.unmodifiableMap(AirlineUtils.singletonMap(CommandMetadata.class, commandMetadata)), state.getParserConfiguration().getCommandFactory());
    }

    protected void validate(ParseState<T> state, List<GlobalRestriction> restrictions) {
        for (GlobalRestriction restriction : restrictions) {
            if (restriction == null) continue;
            restriction.validate(state);
        }
        CommandMetadata command = state.getCommand();
        if (command != null) {
            ArgumentsMetadata arguments = command.getArguments();
            if (arguments != null) {
                for (ArgumentsRestriction restriction : arguments.getRestrictions()) {
                    if (restriction == null) continue;
                    restriction.finalValidate(state, arguments);
                }
            }
            for (OptionMetadata option : command.getAllOptions()) {
                if (option == null) continue;
                for (OptionRestriction restriction : option.getRestrictions()) {
                    if (restriction == null) continue;
                    restriction.finalValidate(state, option);
                }
            }
        }
    }
}

