/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseOptionUnexpectedException;
import com.github.rvesse.airline.parser.options.AbstractOptionParser;
import java.util.List;
import org.apache.commons.collections4.iterators.PeekingIterator;

public class ClassicGetOptParser<T>
extends AbstractOptionParser<T> {
    @Override
    public ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        if (!this.hasShortNamePrefix((String)tokens.peek())) {
            return null;
        }
        String remainingToken = ((String)tokens.peek()).substring(1);
        ParseState<T> nextState = state;
        boolean first = true;
        while (!remainingToken.isEmpty()) {
            char tokenCharacter = remainingToken.charAt(0);
            OptionMetadata option = this.findOption(state, allowedOptions, "-" + tokenCharacter);
            if (option == null) {
                return null;
            }
            nextState = nextState.pushContext(Context.OPTION).withOption(option);
            remainingToken = remainingToken.substring(1);
            if (option.getArity() == 0) {
                nextState = nextState.withOptionValue(option, Boolean.TRUE.toString()).popContext();
                first = false;
                continue;
            }
            if (option.getArity() == 1) {
                tokens.next();
                if (!remainingToken.isEmpty()) {
                    nextState = nextState.withOptionValue(option, remainingToken).popContext();
                } else if (tokens.hasNext()) {
                    nextState = nextState.withOptionValue(option, (String)tokens.next()).popContext();
                }
                return nextState;
            }
            if (first) {
                return null;
            }
            throw new ParseOptionUnexpectedException("Short options style can not be used with option %s", option);
        }
        tokens.next();
        return nextState;
    }
}

