/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingValueException;
import com.github.rvesse.airline.parser.options.AbstractOptionParser;
import java.util.List;
import org.apache.commons.collections4.iterators.PeekingIterator;

public class StandardOptionParser<T>
extends AbstractOptionParser<T> {
    @Override
    public ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        OptionMetadata option = this.findOption(state, allowedOptions, (String)tokens.peek());
        if (option == null) {
            return null;
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        if (option.getArity() == 0) {
            state = state.withOptionValue(option, Boolean.TRUE.toString()).popContext();
        } else if (option.getArity() == 1) {
            if (tokens.hasNext()) {
                state = state.withOptionValue(option, (String)tokens.next()).popContext();
            }
        } else {
            int count;
            boolean hasSeparator = false;
            boolean foundNextOption = false;
            String argsSeparator = state.getParserConfiguration().getArgumentsSeparator();
            for (count = 0; count < option.getArity() && tokens.hasNext() && !hasSeparator; ++count) {
                String peekedToken = (String)tokens.peek();
                hasSeparator = peekedToken.equals(argsSeparator);
                boolean bl = foundNextOption = this.findOption(state, allowedOptions, peekedToken) != null;
                if (hasSeparator || foundNextOption) break;
                state = state.withOptionValue(option, (String)tokens.next());
            }
            if (count != option.getArity()) {
                throw new ParseOptionMissingValueException("Too few option values received for option %s (%d values expected but only found %d)", option.getTitle(), option.getOptions().iterator().next(), option.getArity(), count);
            }
            state = state.popContext();
        }
        return state;
    }
}

