/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import java.util.regex.Pattern;

public class PatternRestriction
extends AbstractCommonRestriction
implements HelpHint {
    private final Pattern pattern;

    public PatternRestriction(String pattern, int flags) {
        this.pattern = Pattern.compile(pattern, flags);
    }

    @Override
    public <T> void preValidate(ParseState<T> state, OptionMetadata option, String value) {
        if (!this.pattern.matcher(value).find()) {
            throw new ParseRestrictionViolatedException("Option '%s' was given value '%s' which does not match the regular expression '%s'", option.getTitle(), value, this.pattern.toString());
        }
    }

    @Override
    public <T> void preValidate(ParseState<T> state, ArgumentsMetadata arguments, String value) {
        if (!this.pattern.matcher(value).find()) {
            throw new ParseRestrictionViolatedException("Argument '%s' was given value '%s' which does not match the regular expression '%s'", AbstractCommonRestriction.getArgumentTitle(state, arguments), value, this.pattern.toString());
        }
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String[]{String.format("This options value must match the regular expression '%s'", this.pattern.toString())};
    }
}

