/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.command.SingleCommandParser;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;

public class SingleCommand<C> {
    private final ParserMetadata<C> parserConfig;
    private final CommandMetadata commandMetadata;
    private final List<GlobalRestriction> restrictions;

    public static <C> SingleCommand<C> singleCommand(Class<C> command) {
        return new SingleCommand<C>(command, null, null);
    }

    public static <C> SingleCommand<C> singleCommand(Class<C> command, ParserMetadata<C> parserConfig) {
        return new SingleCommand<C>(command, null, parserConfig);
    }

    private SingleCommand(Class<C> command, Iterable<GlobalRestriction> restrictions, ParserMetadata<C> parserConfig) {
        if (command == null) {
            throw new NullPointerException("command is null");
        }
        this.parserConfig = parserConfig != null ? parserConfig : MetadataLoader.loadParser(command);
        List list = this.restrictions = restrictions != null ? IteratorUtils.toList(restrictions.iterator()) : AirlineUtils.arrayToList(GlobalRestriction.DEFAULTS);
        if (this.restrictions.size() == 0) {
            this.restrictions.addAll(AirlineUtils.arrayToList(GlobalRestriction.DEFAULTS));
        }
        this.commandMetadata = MetadataLoader.loadCommand(command);
    }

    public CommandMetadata getCommandMetadata() {
        return this.commandMetadata;
    }

    public ParserMetadata<C> getParserConfiguration() {
        return this.parserConfig;
    }

    public C parse(String ... args) {
        return this.parse(AirlineUtils.arrayToList(args));
    }

    public C parse(Iterable<String> args) {
        SingleCommandParser<C> parser = new SingleCommandParser<C>();
        return (C)parser.parse(this.parserConfig, this.commandMetadata, this.restrictions, args);
    }

    public ParseResult<C> parseWithResult(String ... args) {
        return this.parseWithResult(AirlineUtils.arrayToList(args));
    }

    public ParseResult<C> parseWithResult(Iterable<String> args) {
        SingleCommandParser<C> parser = new SingleCommandParser<C>();
        return parser.parseWithResult(this.parserConfig, this.commandMetadata, this.restrictions, args);
    }
}

