/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.builder;

import com.github.rvesse.airline.model.AliasMetadata;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AliasBuilder<C> {
    private final String name;
    private final List<String> arguments = new ArrayList<String>();

    public AliasBuilder(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Alias name cannot be null/empty/whitespace");
        }
        this.name = name;
    }

    public AliasBuilder<C> withArgument(String arg) {
        if (StringUtils.isEmpty((CharSequence)arg)) {
            throw new IllegalArgumentException("Alias argument cannot be null");
        }
        this.arguments.add(arg);
        return this;
    }

    public AliasBuilder<C> withArguments(String ... args) {
        for (String arg : args) {
            if (arg == null) {
                throw new NullPointerException("Alias argument cannot be null");
            }
            this.arguments.add(arg);
        }
        return this;
    }

    public AliasMetadata build() {
        return new AliasMetadata(this.name, this.arguments);
    }
}

