/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.common;

import com.github.rvesse.airline.help.CommandUsageGenerator;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.common.AbstractUsageGenerator;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.utils.comparators.HelpSectionComparator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class AbstractCommandUsageGenerator
extends AbstractUsageGenerator
implements CommandUsageGenerator {
    private final Comparator<? super Map.Entry<Integer, String>> exitCodeComparator;

    public AbstractCommandUsageGenerator() {
        this(UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public AbstractCommandUsageGenerator(boolean includeHidden) {
        this((Comparator<? super HelpHint>)UsageHelper.DEFAULT_HINT_COMPARATOR, (Comparator<? super OptionMetadata>)UsageHelper.DEFAULT_OPTION_COMPARATOR, (Comparator<? super Map.Entry<Integer, String>>)UsageHelper.DEFAULT_EXIT_CODE_COMPARATOR, includeHidden);
    }

    public AbstractCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator) {
        this((Comparator<? super HelpHint>)UsageHelper.DEFAULT_HINT_COMPARATOR, optionComparator, (Comparator<? super Map.Entry<Integer, String>>)UsageHelper.DEFAULT_EXIT_CODE_COMPARATOR, false);
    }

    public AbstractCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        this((Comparator<? super HelpHint>)UsageHelper.DEFAULT_HINT_COMPARATOR, optionComparator, (Comparator<? super Map.Entry<Integer, String>>)UsageHelper.DEFAULT_EXIT_CODE_COMPARATOR, includeHidden);
    }

    public AbstractCommandUsageGenerator(Comparator<? super HelpHint> hintComparator, Comparator<? super OptionMetadata> optionComparator, Comparator<? super Map.Entry<Integer, String>> exitCodeComparator, boolean includeHidden) {
        super(hintComparator, optionComparator, UsageHelper.DEFAULT_COMMAND_COMPARATOR, includeHidden);
        this.exitCodeComparator = exitCodeComparator;
    }

    @Override
    public <T> void usage(String programName, String[] groupNames, String commandName, CommandMetadata command, ParserMetadata<T> parserConfig) throws IOException {
        this.usage(programName, groupNames, commandName, command, parserConfig, System.out);
    }

    @Override
    @Deprecated
    public void usage(String programName, String[] groupNames, String commandName, CommandMetadata command) throws IOException {
        this.usage(programName, groupNames, commandName, command, null, System.out);
    }

    @Override
    @Deprecated
    public void usage(String programName, String[] groupNames, String commandName, CommandMetadata command, OutputStream output) throws IOException {
        this.usage(programName, groupNames, commandName, command, null, output);
    }

    protected List<Map.Entry<Integer, String>> sortExitCodes(List<Map.Entry<Integer, String>> exitCodes) {
        if (this.exitCodeComparator != null) {
            exitCodes = new ArrayList<Map.Entry<Integer, String>>(exitCodes);
            Collections.sort(exitCodes, this.exitCodeComparator);
        }
        return exitCodes;
    }

    protected void findHelpSections(CommandMetadata command, List<HelpSection> preSections, List<HelpSection> postSections) {
        for (HelpSection section : command.getHelpSections()) {
            if (section.suggestedOrder() < 0) {
                preSections.add(section);
                continue;
            }
            postSections.add(section);
        }
        HelpSectionComparator comparator = new HelpSectionComparator();
        Collections.sort(preSections, comparator);
        Collections.sort(postSections, comparator);
    }
}

