/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.aliases;

import com.github.rvesse.airline.model.AliasMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.parser.AbstractParser;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseAliasCircularReferenceException;
import com.github.rvesse.airline.utils.predicates.parser.AliasFinder;
import com.github.rvesse.airline.utils.predicates.parser.CommandFinder;
import com.github.rvesse.airline.utils.predicates.parser.GroupFinder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.PeekingIterator;

public class AliasResolver<T>
extends AbstractParser<T> {
    /*
     * Could not resolve type clashes
     */
    public PeekingIterator<String> resolveAliases(PeekingIterator<String> tokens, ParseState<T> state) {
        if (!tokens.hasNext()) {
            return tokens;
        }
        if (state.getParserConfiguration().getAliases().size() == 0) {
            return tokens;
        }
        TreeSet<String> aliasesSeen = new TreeSet<String>();
        do {
            AliasMetadata alias;
            if ((alias = (AliasMetadata)CollectionUtils.find(state.getParserConfiguration().getAliases(), (Predicate)new AliasFinder((String)tokens.peek()))) == null) {
                return tokens;
            }
            if (!aliasesSeen.add(alias.getName())) {
                state.getParserConfiguration().getErrorHandler().handleError(new ParseAliasCircularReferenceException(alias.getName(), aliasesSeen));
                return tokens;
            }
            if (!state.getParserConfiguration().aliasesOverrideBuiltIns() && state.getGlobal() != null) {
                GlobalMetadata<T> metadata = state.getGlobal();
                GroupFinder findGroupPredicate = new GroupFinder((String)tokens.peek());
                CommandFinder findCommandPredicate = new CommandFinder((String)tokens.peek());
                if (CollectionUtils.find(metadata.getCommandGroups(), (Predicate)findGroupPredicate) != null || CollectionUtils.find(metadata.getDefaultGroupCommands(), (Predicate)findCommandPredicate) != null) {
                    return tokens;
                }
            }
            tokens.next();
            ArrayList newParams = new ArrayList();
            ArrayList<Object> remainingParams = new ArrayList<Object>();
            while (tokens.hasNext()) {
                remainingParams.add(tokens.next());
            }
            TreeSet<Integer> used = new TreeSet<Integer>();
            for (String arg : alias.getArguments()) {
                if (arg.startsWith("$")) {
                    try {
                        int num = Integer.parseInt(arg.substring(1));
                        if (--num >= 0 && num < remainingParams.size()) {
                            newParams.add(remainingParams.get(num));
                            used.add(num);
                            continue;
                        }
                    }
                    catch (NumberFormatException num) {
                        // empty catch block
                    }
                }
                newParams.add(arg);
            }
            int removed = 0;
            Iterator iterator = used.iterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                remainingParams.remove(pos - removed);
                ++removed;
            }
            for (String arg : remainingParams) {
                newParams.add(arg);
            }
            tokens = new PeekingIterator(newParams.iterator());
        } while (state.getParserConfiguration().aliasesMayChain());
        return tokens;
    }
}

