/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.types.numerics.abbreviated;

import com.github.rvesse.airline.types.numerics.abbreviated.AbbreviatedNumericTypeConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MapAbbreviatedNumericTypeConverter
extends AbbreviatedNumericTypeConverter {
    private final boolean caseSensitive;
    private final Map<String, Integer> prefixes = new HashMap<String, Integer>();
    private final Map<String, Long> suffixes = new HashMap<String, Long>();

    public MapAbbreviatedNumericTypeConverter(boolean caseSensitive, Map<String, Integer> prefixes, Map<String, Long> suffixes) {
        this.caseSensitive = caseSensitive;
        if (!this.caseSensitive) {
            this.prefixes.putAll(prefixes);
            this.suffixes.putAll(suffixes);
        } else {
            for (Map.Entry<String, Integer> entry : prefixes.entrySet()) {
                this.prefixes.put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue());
            }
            for (Map.Entry<String, Number> entry : suffixes.entrySet()) {
                this.suffixes.put(entry.getKey().toLowerCase(Locale.ROOT), (Long)entry.getValue());
            }
        }
    }

    @Override
    protected Collection<String> getPermittedPrefixes() {
        return this.prefixes.keySet();
    }

    @Override
    protected Collection<String> getPermittedSuffixes() {
        return this.suffixes.keySet();
    }

    @Override
    protected long getMultiplier(String suffix) {
        suffix = this.caseSensitive ? suffix : suffix.toLowerCase(Locale.ROOT);
        Long m = null;
        m = this.suffixes.containsKey(suffix) ? this.suffixes.get(suffix) : Long.valueOf(1L);
        if (m == null) {
            m = 1L;
        }
        return m;
    }

    @Override
    protected int getRadix(String prefix) {
        prefix = this.caseSensitive ? prefix : prefix.toLowerCase(Locale.ROOT);
        Integer r = null;
        r = this.prefixes.containsKey(prefix) ? this.prefixes.get(prefix) : Integer.valueOf(10);
        if (r == null) {
            r = 10;
        }
        return r;
    }
}

