/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser;

import com.github.rvesse.airline.Accessor;
import com.github.rvesse.airline.CommandFactory;
import com.github.rvesse.airline.DefaultCommandFactory;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.errors.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ParserUtil {
    public static <T> T createInstance(Class<T> type) {
        if (type != null) {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ParseException(e, "Unable to create instance %s", type.getName());
            }
        }
        return null;
    }

    public static <T> T createInstance(Class<?> type, Iterable<OptionMetadata> options, List<Pair<OptionMetadata, Object>> parsedOptions, ArgumentsMetadata arguments, Iterable<Object> parsedArguments, Iterable<Accessor> metadataInjection, Map<Class<?>, Object> bindings) {
        return ParserUtil.createInstance(type, options, parsedOptions, arguments, parsedArguments, metadataInjection, bindings, new DefaultCommandFactory());
    }

    public static <T> T injectOptions(T commandInstance, Iterable<OptionMetadata> options, List<Pair<OptionMetadata, Object>> parsedOptions, ArgumentsMetadata arguments, Iterable<Object> parsedArguments, Iterable<Accessor> metadataInjection, Map<Class<?>, Object> bindings) {
        for (OptionMetadata option : options) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Pair<OptionMetadata, Object> parsedOption : parsedOptions) {
                if (!option.equals(parsedOption.getLeft())) continue;
                values.add(parsedOption.getRight());
            }
            if (values == null || values.isEmpty()) continue;
            for (Accessor accessor : option.getAccessors()) {
                accessor.addValues(commandInstance, values);
            }
        }
        if (arguments != null && parsedArguments != null) {
            for (Accessor accessor : arguments.getAccessors()) {
                accessor.addValues(commandInstance, parsedArguments);
            }
        }
        for (Accessor accessor : metadataInjection) {
            Object injectee = bindings.get(accessor.getJavaType());
            if (injectee == null) continue;
            accessor.addValues(commandInstance, ListUtils.unmodifiableList(Collections.singletonList(injectee)));
        }
        return commandInstance;
    }

    public static <T> T createInstance(Class<?> type, Iterable<OptionMetadata> options, List<Pair<OptionMetadata, Object>> parsedOptions, ArgumentsMetadata arguments, Iterable<Object> parsedArguments, Iterable<Accessor> metadataInjection, Map<Class<?>, Object> bindings, CommandFactory<T> commandFactory) {
        T commandInstance = commandFactory.createInstance(type);
        return ParserUtil.injectOptions(commandInstance, options, parsedOptions, arguments, parsedArguments, metadataInjection, bindings);
    }
}

