/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.aliases;

import com.github.rvesse.airline.builder.AliasBuilder;
import com.github.rvesse.airline.model.AliasMetadata;
import com.github.rvesse.airline.parser.aliases.AliasArgumentsParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class UserAliasesSource<C> {
    private final List<String> searchLocations;
    private final String filename;
    private final String prefix;

    public UserAliasesSource(String filename, String prefix, String ... searchLocations) {
        this.filename = filename;
        this.prefix = prefix;
        this.searchLocations = Collections.unmodifiableList(Arrays.asList(searchLocations));
        if (StringUtils.isBlank((CharSequence)this.filename)) {
            throw new IllegalArgumentException("Filename cannot be null/empty/blank");
        }
        if (this.searchLocations.size() == 0) {
            throw new IllegalArgumentException("At least one search location must be specified");
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public List<String> getSearchLocations() {
        return this.searchLocations;
    }

    public String getPrefix() {
        return this.prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AliasMetadata> load() throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        File homeDir = null;
        if (!StringUtils.isEmpty((CharSequence)System.getProperty("user.home"))) {
            homeDir = new File(System.getProperty("user.home"));
        }
        HashSet<String> loaded = new HashSet<String>();
        for (int i = this.searchLocations.size() - 1; i >= 0; --i) {
            String loc = this.searchLocations.get(i);
            if (StringUtils.isBlank((CharSequence)loc)) continue;
            if (loc.startsWith("~" + File.separator)) {
                if (homeDir == null) continue;
                loc = homeDir.getAbsolutePath() + loc.substring(homeDir.getAbsolutePath().endsWith(File.separator) ? 2 : 1);
            }
            if (loaded.contains(loc)) continue;
            File f = new File(loc);
            if (!(f = new File(f, this.filename)).exists() || !f.isFile() || !f.canRead()) continue;
            try (FileInputStream input = new FileInputStream(f);){
                properties.load(input);
                continue;
            }
            finally {
                loaded.add(loc);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.prefix)) {
            ArrayList<Object> keysToRemove = new ArrayList<Object>();
            for (Object key : properties.keySet()) {
                if (key.toString().startsWith(this.prefix)) continue;
                keysToRemove.add(key);
            }
            for (Object key : keysToRemove) {
                properties.remove(key);
            }
        }
        ArrayList<AliasMetadata> aliases = new ArrayList<AliasMetadata>();
        for (Object key : properties.keySet()) {
            String name = key.toString();
            if (!StringUtils.isBlank((CharSequence)this.prefix)) {
                name = name.substring(this.prefix.length());
            }
            AliasBuilder alias = new AliasBuilder(name);
            String value = properties.getProperty(key.toString());
            if (StringUtils.isEmpty((CharSequence)value)) {
                aliases.add(alias.build());
                continue;
            }
            List<String> args = AliasArgumentsParser.parse(value);
            alias.withArguments(args.toArray(new String[args.size()]));
            aliases.add(alias.build());
        }
        return aliases;
    }
}

