/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.types.numerics.abbreviated;

import com.github.rvesse.airline.types.numerics.ComplexNumericTypeConverter;
import com.github.rvesse.airline.types.numerics.NumericCandidate;
import java.util.Collection;

public abstract class AbbreviatedNumericTypeConverter
extends ComplexNumericTypeConverter {
    protected abstract Collection<String> getPermittedPrefixes();

    protected abstract Collection<String> getPermittedSuffixes();

    @Override
    protected NumericCandidate parse(String value) {
        String origValue = value;
        String prefix = null;
        for (String p : this.getPermittedPrefixes()) {
            if (!value.startsWith(p)) continue;
            prefix = p;
            value = value.substring(p.length());
            break;
        }
        String suffix = null;
        for (String s : this.getPermittedSuffixes()) {
            if (!value.endsWith(s)) continue;
            suffix = s;
            value = value.substring(0, value.length() - s.length());
            break;
        }
        return new NumericCandidate(prefix, value, suffix, origValue);
    }

    @Override
    protected long getMultiplier(NumericCandidate candidate) {
        return candidate.hasSuffix() ? this.getMultiplier(candidate.getSuffix()) : super.getMultiplier(candidate);
    }

    @Override
    protected int getRadix(NumericCandidate candidate) {
        return candidate.hasPrefix() ? this.getRadix(candidate.getPrefix()) : super.getRadix(candidate);
    }

    protected abstract long getMultiplier(String var1);

    protected abstract int getRadix(String var1);
}

