/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.utils.predicates;

import com.github.rvesse.airline.utils.predicates.AbstractLocaleSensitiveStringFinder;
import java.util.Locale;

public class PrefixMatcher
extends AbstractLocaleSensitiveStringFinder {
    private final String[] prefixes;
    private final boolean ignoreCase;

    public PrefixMatcher(boolean ignoreCase, Locale locale, String ... prefixes) {
        super(locale);
        this.ignoreCase = ignoreCase;
        this.prefixes = prefixes;
        if (ignoreCase) {
            int i = 0;
            while (i < this.prefixes.length) {
                this.prefixes[i] = this.prefixes[i].toLowerCase(locale);
                ++i;
            }
        }
    }

    public boolean evaluate(String str) {
        String[] stringArray = this.prefixes;
        int n = this.prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (str.length() < prefix.length()) {
                return false;
            }
            String strPrefix = str.substring(0, prefix.length());
            if (this.ignoreCase) {
                strPrefix = strPrefix.toLowerCase(this.locale);
            }
            if (this.collator.compare(strPrefix, prefix) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

