/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.model;

import com.github.rvesse.airline.Accessor;
import com.github.rvesse.airline.DefaultCommandFactory;
import com.github.rvesse.airline.annotations.Alias;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Cli;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.DefaultOption;
import com.github.rvesse.airline.annotations.Group;
import com.github.rvesse.airline.annotations.Groups;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.Parser;
import com.github.rvesse.airline.annotations.restrictions.Partial;
import com.github.rvesse.airline.annotations.restrictions.Partials;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.builder.UserAliasSourceBuilder;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.help.sections.factories.HelpSectionRegistry;
import com.github.rvesse.airline.help.suggester.Suggester;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.model.SuggesterMetadata;
import com.github.rvesse.airline.parser.ParserUtil;
import com.github.rvesse.airline.parser.errors.handlers.FailFast;
import com.github.rvesse.airline.parser.options.OptionParser;
import com.github.rvesse.airline.parser.resources.ResourceLocator;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.PartialRestriction;
import com.github.rvesse.airline.restrictions.factories.RestrictionRegistry;
import com.github.rvesse.airline.types.DefaultTypeConverter;
import com.github.rvesse.airline.types.TypeConverterProvider;
import com.github.rvesse.airline.types.numerics.DefaultNumericConverter;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.comparators.StringHierarchyComparator;
import com.github.rvesse.airline.utils.predicates.parser.CommandTypeFinder;
import com.github.rvesse.airline.utils.predicates.parser.GroupFinder;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class MetadataLoader {
    public static <C> ParserMetadata<C> loadParser(Class<?> cliClass) {
        if (cliClass == null) {
            return ParserBuilder.defaultConfiguration();
        }
        Parser annotation = cliClass.getAnnotation(Parser.class);
        if (annotation == null) {
            return ParserBuilder.defaultConfiguration();
        }
        return MetadataLoader.loadParser(annotation);
    }

    private static <C> ParserMetadata<C> loadParser(Parser parserConfig) {
        ParserBuilder builder = new ParserBuilder();
        builder = !parserConfig.typeConverter().equals(DefaultTypeConverter.class) ? builder.withTypeConverter(ParserUtil.createInstance(parserConfig.typeConverter())) : builder.withDefaultTypeConverter();
        builder = !parserConfig.numericTypeConverter().equals(DefaultNumericConverter.class) ? builder.withNumericTypeConverter(ParserUtil.createInstance(parserConfig.numericTypeConverter())) : builder.withDefaultNumericTypeConverter();
        builder = !parserConfig.commandFactory().equals(DefaultCommandFactory.class) ? builder.withCommandFactory(ParserUtil.createInstance(parserConfig.commandFactory())) : builder.withDefaultCommandFactory();
        builder = !parserConfig.errorHandler().equals(FailFast.class) ? builder.withErrorHandler(ParserUtil.createInstance(parserConfig.errorHandler())) : builder.withDefaultErrorHandler();
        if (parserConfig.allowCommandAbbreviation()) {
            builder = builder.withCommandAbbreviation();
        }
        if (parserConfig.allowOptionAbbreviation()) {
            builder = builder.withOptionAbbreviation();
        }
        if (parserConfig.aliasesOverrideBuiltIns()) {
            builder = builder.withAliasesOverridingBuiltIns();
        }
        if (parserConfig.aliasesMayChain()) {
            builder = builder.withAliasesChaining();
        }
        builder = builder.withAliasForceBuiltInPrefix(parserConfig.aliasesForceBuiltInPrefix());
        for (Alias alias : parserConfig.aliases()) {
            builder.withAlias(alias.name()).withArguments(alias.arguments());
        }
        if (!StringUtils.isEmpty((CharSequence)parserConfig.userAliasesFile())) {
            UserAliasSourceBuilder userAliasBuilder = builder.withUserAliases();
            userAliasBuilder.withFilename(parserConfig.userAliasesFile());
            userAliasBuilder.withPrefix(parserConfig.userAliasesPrefix());
            if (parserConfig.userAliasesSearchLocation().length > 0) {
                userAliasBuilder.withSearchLocations(parserConfig.userAliasesSearchLocation());
            } else {
                userAliasBuilder.withSearchLocation("." + File.separator);
            }
            if (parserConfig.useDefaultAliasLocators() && parserConfig.defaultAliasLocatorsFirst()) {
                userAliasBuilder.withDefaultLocators();
            }
            ResourceLocator[] resourceLocatorArray = ParserUtil.createResourceLocators(parserConfig.userAliasLocators());
            int n = resourceLocatorArray.length;
            for (int alias = 0; alias < n; ++alias) {
                ResourceLocator locator = resourceLocatorArray[alias];
                userAliasBuilder.withLocator(locator);
            }
            if (parserConfig.useDefaultAliasLocators() && !parserConfig.defaultAliasLocatorsFirst()) {
                userAliasBuilder.withDefaultLocators();
            }
        }
        builder.withArgumentsSeparator(parserConfig.argumentsSeparator());
        builder.withFlagNegationPrefix(parserConfig.flagNegationPrefix());
        if (parserConfig.defaultParsersFirst() && parserConfig.useDefaultOptionParsers()) {
            builder = builder.withDefaultOptionParsers();
        }
        for (Class<? extends OptionParser> optionParserClass : parserConfig.optionParsers()) {
            OptionParser optionParser = (OptionParser)ParserUtil.createInstance(optionParserClass);
            builder = builder.withOptionParser(optionParser);
        }
        if (!parserConfig.defaultParsersFirst() && parserConfig.useDefaultOptionParsers()) {
            builder = builder.withDefaultOptionParsers();
        }
        return builder.build();
    }

    public static <C> GlobalMetadata<C> loadGlobal(Class<?> cliClass) {
        return MetadataLoader.loadGlobal(cliClass, null);
    }

    public static <C> GlobalMetadata<C> loadGlobal(Class<?> cliClass, ParserMetadata<C> parserConfigOverride) {
        Annotation annotation = cliClass.getAnnotation(Cli.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Class %s does not have the @Cli annotation", cliClass));
        }
        Cli cliConfig = annotation;
        Map<String, HelpSection> baseHelpSections = MetadataLoader.loadHelpSections(cliClass, Collections.emptyMap());
        CommandMetadata defaultCommand = null;
        if (!cliConfig.defaultCommand().equals(Cli.NO_DEFAULT.class)) {
            defaultCommand = MetadataLoader.loadCommand(cliConfig.defaultCommand(), new HashMap<String, HelpSection>(baseHelpSections));
        }
        ArrayList<CommandMetadata> defaultGroupCommands = new ArrayList<CommandMetadata>();
        for (Class<?> cls : cliConfig.commands()) {
            defaultGroupCommands.add(MetadataLoader.loadCommand(cls, new HashMap<String, HelpSection>(baseHelpSections)));
        }
        ParserMetadata<C> parserConfig = parserConfigOverride != null ? parserConfigOverride : (cliConfig.parserConfiguration() != null ? MetadataLoader.loadParser(cliConfig.parserConfiguration()) : MetadataLoader.loadParser(cliClass));
        ArrayList<GlobalRestriction> restrictions = new ArrayList<GlobalRestriction>();
        for (Class<? extends Annotation> annotationClass : RestrictionRegistry.getGlobalRestrictionAnnotationClasses()) {
            GlobalRestriction restriction;
            annotation = cliClass.getAnnotation(annotationClass);
            if (annotation == null || (restriction = RestrictionRegistry.getGlobalRestriction(annotationClass, annotation)) == null) continue;
            restrictions.add(restriction);
        }
        for (Class<? extends GlobalRestriction> cls : cliConfig.restrictions()) {
            restrictions.add(ParserUtil.createInstance(cls));
        }
        if (cliConfig.includeDefaultRestrictions()) {
            restrictions.addAll(Arrays.asList(GlobalRestriction.DEFAULTS));
        }
        TreeMap<String, CommandGroupMetadata> subGroups = new TreeMap<String, CommandGroupMetadata>(new StringHierarchyComparator());
        ArrayList<CommandGroupMetadata> groups = new ArrayList<CommandGroupMetadata>();
        for (Group groupAnno : cliConfig.groups()) {
            CommandGroupMetadata group;
            String groupName = groupAnno.name();
            String subGroupPath = null;
            if (StringUtils.containsWhitespace((CharSequence)groupName)) {
                subGroupPath = StringUtils.join((Object[])StringUtils.split((String)groupAnno.name()), (char)' ');
            }
            if ((group = (CommandGroupMetadata)CollectionUtils.find(groups, (Predicate)new GroupFinder(groupName))) == null) {
                group = (CommandGroupMetadata)subGroups.get(subGroupPath);
            }
            ArrayList<CommandMetadata> groupCommands = new ArrayList<CommandMetadata>();
            for (Class<?> cls : groupAnno.commands()) {
                groupCommands.add(MetadataLoader.loadCommand(cls, new HashMap<String, HelpSection>(baseHelpSections)));
            }
            if (group == null) {
                group = MetadataLoader.loadCommandGroup(subGroupPath != null ? subGroupPath : groupName, groupAnno.description(), groupAnno.hidden(), Collections.emptyList(), !groupAnno.defaultCommand().equals(Group.NO_DEFAULT.class) ? MetadataLoader.loadCommand(groupAnno.defaultCommand(), baseHelpSections) : null, groupCommands);
                if (subGroupPath == null) {
                    groups.add(group);
                    continue;
                }
                subGroups.put(subGroupPath, group);
                continue;
            }
            for (CommandMetadata cmd : groupCommands) {
                group.addCommand(cmd);
            }
        }
        MetadataLoader.buildGroupsHierarchy(groups, subGroups);
        ArrayList<CommandMetadata> allCommands = new ArrayList<CommandMetadata>();
        allCommands.addAll(defaultGroupCommands);
        if (defaultCommand != null && !defaultGroupCommands.contains(defaultCommand)) {
            allCommands.add(defaultCommand);
        }
        for (CommandGroupMetadata group : groups) {
            allCommands.addAll(group.getCommands());
            if (group.getDefaultCommand() != null) {
                allCommands.add(group.getDefaultCommand());
            }
            LinkedList<CommandGroupMetadata> subGroupsQueue = new LinkedList<CommandGroupMetadata>();
            subGroupsQueue.addAll(group.getSubGroups());
            while (subGroupsQueue.size() > 0) {
                CommandGroupMetadata subGroup = (CommandGroupMetadata)subGroupsQueue.poll();
                allCommands.addAll(subGroup.getCommands());
                if (subGroup.getDefaultCommand() != null) {
                    allCommands.add(subGroup.getDefaultCommand());
                }
                subGroupsQueue.addAll(subGroup.getSubGroups());
            }
        }
        MetadataLoader.loadCommandsIntoGroupsByAnnotation(allCommands, groups, defaultGroupCommands, baseHelpSections);
        return MetadataLoader.loadGlobal(cliConfig.name(), cliConfig.description(), defaultCommand, defaultGroupCommands, groups, restrictions, baseHelpSections.values(), parserConfig);
    }

    public static <C> GlobalMetadata<C> loadGlobal(String name, String description, CommandMetadata defaultCommand, Iterable<CommandMetadata> defaultGroupCommands, Iterable<CommandGroupMetadata> groups, Iterable<GlobalRestriction> restrictions, Iterable<HelpSection> baseHelpSections, ParserMetadata<C> parserConfig) {
        List<OptionMetadata> globalOptions = new ArrayList<OptionMetadata>();
        if (defaultCommand != null) {
            globalOptions.addAll(defaultCommand.getGlobalOptions());
        }
        for (CommandMetadata command : defaultGroupCommands) {
            globalOptions.addAll(command.getGlobalOptions());
        }
        for (CommandGroupMetadata group : groups) {
            for (CommandMetadata command : group.getCommands()) {
                globalOptions.addAll(command.getGlobalOptions());
            }
            LinkedList<CommandGroupMetadata> subGroups = new LinkedList<CommandGroupMetadata>();
            subGroups.addAll(group.getSubGroups());
            while (subGroups.size() > 0) {
                CommandGroupMetadata subGroup = (CommandGroupMetadata)subGroups.poll();
                for (CommandMetadata command : subGroup.getCommands()) {
                    globalOptions.addAll(command.getGlobalOptions());
                }
                subGroups.addAll(subGroup.getSubGroups());
            }
        }
        globalOptions = ListUtils.unmodifiableList(MetadataLoader.mergeOptionSet(globalOptions));
        return new GlobalMetadata<C>(name, description, globalOptions, defaultCommand, defaultGroupCommands, groups, restrictions, baseHelpSections, parserConfig);
    }

    public static CommandGroupMetadata loadCommandGroup(String name, String description, boolean hidden, Iterable<CommandGroupMetadata> subGroups, CommandMetadata defaultCommand, Iterable<CommandMetadata> commands) {
        if (StringUtils.containsWhitespace((CharSequence)name)) {
            String[] names = StringUtils.split((String)name);
            name = names[names.length - 1];
        }
        List<OptionMetadata> groupOptions = new ArrayList<OptionMetadata>();
        if (defaultCommand != null) {
            groupOptions.addAll(defaultCommand.getGroupOptions());
        }
        for (CommandMetadata command : commands) {
            groupOptions.addAll(command.getGroupOptions());
        }
        groupOptions = ListUtils.unmodifiableList(MetadataLoader.mergeOptionSet(groupOptions));
        return new CommandGroupMetadata(name, description, hidden, groupOptions, subGroups, defaultCommand, commands);
    }

    public static <T> List<CommandMetadata> loadCommands(Iterable<Class<? extends T>> defaultCommands, Map<String, HelpSection> baseHelpSections) {
        ArrayList<CommandMetadata> commandMetadata = new ArrayList<CommandMetadata>();
        Iterator<Class<T>> iter = defaultCommands.iterator();
        while (iter.hasNext()) {
            commandMetadata.add(MetadataLoader.loadCommand(iter.next(), baseHelpSections));
        }
        return commandMetadata;
    }

    public static CommandMetadata loadCommand(Class<?> commandType) {
        return MetadataLoader.loadCommand(commandType, new HashMap<String, HelpSection>());
    }

    public static CommandMetadata loadCommand(Class<?> commandType, Map<String, HelpSection> baseHelpSections) {
        if (commandType == null) {
            return null;
        }
        Command command = null;
        ArrayList<Group> groups = new ArrayList<Group>();
        Class<?> cls = commandType;
        while (command == null && !Object.class.equals(cls)) {
            command = cls.getAnnotation(Command.class);
            if (cls.isAnnotationPresent(Groups.class)) {
                groups.addAll(Arrays.asList(cls.getAnnotation(Groups.class).value()));
            }
            if (cls.isAnnotationPresent(Group.class)) {
                groups.add(cls.getAnnotation(Group.class));
            }
            cls = cls.getSuperclass();
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Command %s is not annotated with @Command", commandType.getName()));
        }
        Map<String, HelpSection> helpSections = MetadataLoader.loadHelpSections(commandType, baseHelpSections);
        String name = command.name();
        String description = command.description().isEmpty() ? null : command.description();
        List<String> groupNames = Arrays.asList(command.groupNames());
        boolean hidden = command.hidden();
        InjectionMetadata injectionMetadata = MetadataLoader.loadInjectionMetadata(commandType);
        CommandMetadata commandMetadata = new CommandMetadata(name, description, hidden, injectionMetadata.globalOptions, injectionMetadata.groupOptions, injectionMetadata.commandOptions, injectionMetadata.defaultOption, AirlineUtils.first(injectionMetadata.arguments, null), injectionMetadata.metadataInjections, commandType, groupNames, groups, AirlineUtils.listCopy(helpSections.values()));
        return commandMetadata;
    }

    protected static Map<String, HelpSection> loadHelpSections(Class<?> sourceClass, Map<String, HelpSection> baseHelpSections) {
        HashMap<String, HelpSection> helpSections = new HashMap<String, HelpSection>();
        Class<?> cls = sourceClass;
        while (!Object.class.equals(cls)) {
            for (Class<? extends Annotation> helpAnnotationClass : HelpSectionRegistry.getAnnotationClasses()) {
                HelpSection section;
                Annotation annotation = cls.getAnnotation(helpAnnotationClass);
                if (annotation == null || (section = HelpSectionRegistry.getHelpSection(helpAnnotationClass, annotation)) == null || helpSections.containsKey(section.getTitle().toLowerCase(Locale.ENGLISH))) continue;
                helpSections.put(section.getTitle().toLowerCase(Locale.ENGLISH), section);
            }
            cls = cls.getSuperclass();
        }
        if (baseHelpSections.isEmpty()) {
            return helpSections;
        }
        for (String key : baseHelpSections.keySet()) {
            if (helpSections.containsKey(key.toLowerCase(Locale.ENGLISH))) continue;
            helpSections.put(key.toLowerCase(Locale.ENGLISH), baseHelpSections.get(key));
        }
        return helpSections;
    }

    public static SuggesterMetadata loadSuggester(Class<? extends Suggester> suggesterClass) {
        InjectionMetadata injectionMetadata = MetadataLoader.loadInjectionMetadata(suggesterClass);
        return new SuggesterMetadata(suggesterClass, injectionMetadata.metadataInjections);
    }

    public static InjectionMetadata loadInjectionMetadata(Class<?> type) {
        InjectionMetadata injectionMetadata = new InjectionMetadata();
        MetadataLoader.loadInjectionMetadata(type, injectionMetadata, Collections.emptyList());
        injectionMetadata.compact();
        return injectionMetadata;
    }

    public static void loadInjectionMetadata(Class<?> type, InjectionMetadata injectionMetadata, List<Field> fields) {
        if (type.isInterface()) {
            return;
        }
        Class<?> cls = type;
        while (!Object.class.equals(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                field.setAccessible(true);
                ArrayList<Field> path = new ArrayList<Field>(fields);
                path.add(field);
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (injectAnnotation != null) {
                    if (field.getType().equals(GlobalMetadata.class) || field.getType().equals(CommandGroupMetadata.class) || field.getType().equals(CommandMetadata.class)) {
                        injectionMetadata.metadataInjections.add(new Accessor((List<Field>)path));
                    } else {
                        MetadataLoader.loadInjectionMetadata(field.getType(), injectionMetadata, path);
                    }
                }
                try {
                    Object aGuiceInject = field.getAnnotation(Class.forName("com.google.inject.Inject"));
                    if (aGuiceInject != null) {
                        if (field.getType().equals(GlobalMetadata.class) || field.getType().equals(CommandGroupMetadata.class) || field.getType().equals(CommandMetadata.class)) {
                            injectionMetadata.metadataInjections.add(new Accessor((List<Field>)path));
                        } else {
                            MetadataLoader.loadInjectionMetadata(field.getType(), injectionMetadata, path);
                        }
                    }
                }
                catch (ClassNotFoundException aGuiceInject) {
                }
                catch (ClassCastException aGuiceInject) {
                    // empty catch block
                }
                Option optionAnnotation = field.getAnnotation(Option.class);
                DefaultOption defaultOptionAnnotation = field.getAnnotation(DefaultOption.class);
                if (optionAnnotation != null) {
                    Class<?> fieldType;
                    OptionType optionType = optionAnnotation.type();
                    String name = !optionAnnotation.title().isEmpty() ? optionAnnotation.title() : field.getName();
                    List<String> options = Arrays.asList(optionAnnotation.name());
                    String description = optionAnnotation.description();
                    int arity = optionAnnotation.arity();
                    if (arity < 0 && arity != Integer.MIN_VALUE) {
                        throw new IllegalArgumentException(String.format("Invalid arity for option %s", name));
                    }
                    arity = optionAnnotation.arity() >= 0 ? optionAnnotation.arity() : (Boolean.class.isAssignableFrom(fieldType = field.getType()) || Boolean.TYPE.isAssignableFrom(fieldType) ? 0 : 1);
                    boolean hidden = optionAnnotation.hidden();
                    boolean override = optionAnnotation.override();
                    boolean sealed = optionAnnotation.sealed();
                    Map<Class<? extends Annotation>, Set<Integer>> partials = MetadataLoader.loadPartials(field);
                    ArrayList<OptionRestriction> restrictions = new ArrayList<OptionRestriction>();
                    for (Class<? extends Annotation> annotationClass : RestrictionRegistry.getOptionRestrictionAnnotationClasses()) {
                        OptionRestriction restriction;
                        Annotation annotation = field.getAnnotation(annotationClass);
                        if (annotation == null || (restriction = RestrictionRegistry.getOptionRestriction(annotationClass, annotation)) == null) continue;
                        if (partials.containsKey(annotationClass)) {
                            restriction = new PartialRestriction((Collection<Integer>)partials.get(annotationClass), restriction);
                        }
                        restrictions.add(restriction);
                    }
                    TypeConverterProvider provider = ParserUtil.createInstance(optionAnnotation.typeConverterProvider());
                    OptionMetadata optionMetadata = new OptionMetadata(optionType, options, name, description, arity, hidden, override, sealed, restrictions, provider, path);
                    switch (optionType) {
                        case GLOBAL: {
                            if (defaultOptionAnnotation != null) {
                                throw new IllegalArgumentException(String.format("Field %s which defines a global option cannot be annotated with @DefaultOption as this may only be applied to command options", field));
                            }
                            injectionMetadata.globalOptions.add(optionMetadata);
                            break;
                        }
                        case GROUP: {
                            if (defaultOptionAnnotation != null) {
                                throw new IllegalArgumentException(String.format("Field %s which defines a global option cannot be annotated with @DefaultOption as this may only be applied to command options", field));
                            }
                            injectionMetadata.groupOptions.add(optionMetadata);
                            break;
                        }
                        case COMMAND: {
                            if (defaultOptionAnnotation != null) {
                                if (injectionMetadata.arguments.size() > 0) {
                                    throw new IllegalArgumentException(String.format("Field %s cannot be annotated with @DefaultOption because there are fields with @Arguments annotations present", field));
                                }
                                if (injectionMetadata.defaultOption != null) {
                                    throw new IllegalArgumentException(String.format("Command type %s has more than one field with @DefaultOption declared upon it", type));
                                }
                                if (optionMetadata.getArity() != 1) {
                                    throw new IllegalArgumentException(String.format("Field %s annotated with @DefaultOption must also have an @Option annotation with an arity of 1", field));
                                }
                                injectionMetadata.defaultOption = optionMetadata;
                            }
                            injectionMetadata.commandOptions.add(optionMetadata);
                        }
                    }
                }
                if (optionAnnotation == null && defaultOptionAnnotation != null) {
                    throw new IllegalArgumentException(String.format("Field %s annotated with @DefaultOption must also have an @Option annotation", field));
                }
                Arguments argumentsAnnotation = field.getAnnotation(Arguments.class);
                if (!field.isAnnotationPresent(Arguments.class)) continue;
                if (injectionMetadata.defaultOption != null) {
                    throw new IllegalArgumentException(String.format("Field %s cannot be annotated with @Arguments because there is a field with @DefaultOption present", field));
                }
                ArrayList<String> titles = new ArrayList<String>();
                if (argumentsAnnotation.title().length != 1 || !argumentsAnnotation.title()[0].equals("")) {
                    titles.addAll(Arrays.asList(argumentsAnnotation.title()));
                } else {
                    titles.add(field.getName());
                }
                String description = argumentsAnnotation.description();
                TypeConverterProvider provider = ParserUtil.createInstance(argumentsAnnotation.typeConverterProvider());
                Map<Class<? extends Annotation>, Set<Integer>> partials = MetadataLoader.loadPartials(field);
                ArrayList<ArgumentsRestriction> restrictions = new ArrayList<ArgumentsRestriction>();
                for (Class<? extends Annotation> annotationClass : RestrictionRegistry.getArgumentsRestrictionAnnotationClasses()) {
                    ArgumentsRestriction restriction;
                    Annotation annotation = field.getAnnotation(annotationClass);
                    if (annotation == null || (restriction = RestrictionRegistry.getArgumentsRestriction(annotationClass, annotation)) == null) continue;
                    if (partials.containsKey(annotationClass)) {
                        restriction = new PartialRestriction((Collection<Integer>)partials.get(annotationClass), restriction);
                    }
                    restrictions.add(restriction);
                }
                injectionMetadata.arguments.add(new ArgumentsMetadata(titles, description, restrictions, provider, path));
            }
            cls = cls.getSuperclass();
        }
    }

    private static Map<Class<? extends Annotation>, Set<Integer>> loadPartials(Field field) {
        Partial partialAnnotation;
        HashMap<Class<? extends Annotation>, Set<Integer>> partials = new HashMap<Class<? extends Annotation>, Set<Integer>>();
        Partials partialsAnnotation = field.getAnnotation(Partials.class);
        if (partialsAnnotation != null) {
            for (Partial partial : partialsAnnotation.value()) {
                MetadataLoader.collectPartial(partials, partial);
            }
        }
        if ((partialAnnotation = field.getAnnotation(Partial.class)) != null) {
            MetadataLoader.collectPartial(partials, partialAnnotation);
        }
        return partials;
    }

    private static void collectPartial(Map<Class<? extends Annotation>, Set<Integer>> partials, Partial partial) {
        Set<Integer> indices = partials.get(partial.restriction());
        if (indices == null) {
            indices = new HashSet<Integer>();
            partials.put(partial.restriction(), indices);
        }
        indices.addAll(Arrays.asList(ArrayUtils.toObject((int[])partial.appliesTo())));
    }

    private static List<OptionMetadata> mergeOptionSet(List<OptionMetadata> options) {
        HashMap<OptionMetadata, ArrayList<OptionMetadata>> metadataIndex = new HashMap<OptionMetadata, ArrayList<OptionMetadata>>();
        for (OptionMetadata option : options) {
            ArrayList<OptionMetadata> list = (ArrayList<OptionMetadata>)metadataIndex.get(option);
            if (list == null) {
                list = new ArrayList<OptionMetadata>();
                metadataIndex.put(option, list);
            }
            list.add(option);
        }
        options = new ArrayList<OptionMetadata>();
        for (List ops : metadataIndex.values()) {
            options.add(new OptionMetadata(ops));
        }
        options = ListUtils.unmodifiableList(options);
        LinkedHashMap<String, OptionMetadata> optionIndex = new LinkedHashMap<String, OptionMetadata>();
        for (OptionMetadata option : options) {
            for (String optionName : option.getOptions()) {
                if (optionIndex.containsKey(optionName)) {
                    throw new IllegalArgumentException(String.format("Fields %s and %s have conflicting definitions of option %s", ((OptionMetadata)optionIndex.get(optionName)).getAccessors().iterator().next(), option.getAccessors().iterator().next(), optionName));
                }
                optionIndex.put(optionName, option);
            }
        }
        return options;
    }

    private static List<OptionMetadata> overrideOptionSet(List<OptionMetadata> options) {
        options = ListUtils.unmodifiableList(options);
        HashMap<Set<String>, OptionMetadata> optionIndex = new HashMap<Set<String>, OptionMetadata>();
        for (OptionMetadata option : options) {
            Set<String> names = option.getOptions();
            if (optionIndex.containsKey(names)) {
                MetadataLoader.tryOverrideOptions(optionIndex, names, option);
                continue;
            }
            for (Set existingNames : optionIndex.keySet()) {
                Set<String> intersection = AirlineUtils.intersection(names, existingNames);
                if (intersection.size() <= 0) continue;
                throw new IllegalArgumentException(String.format("Fields %s and %s have overlapping definitions of option %s, options can only be overridden if they have precisely the same set of option names", option.getAccessors().iterator().next(), ((OptionMetadata)optionIndex.get(existingNames)).getAccessors().iterator().next(), intersection));
            }
            optionIndex.put(names, option);
        }
        return ListUtils.unmodifiableList((List)IteratorUtils.toList(optionIndex.values().iterator()));
    }

    private static void tryOverrideOptions(Map<Set<String>, OptionMetadata> optionIndex, Set<String> names, OptionMetadata parent) {
        boolean isDuplicate;
        OptionMetadata child = optionIndex.get(names);
        Accessor parentField = parent.getAccessors().iterator().next();
        Accessor childField = child.getAccessors().iterator().next();
        boolean bl = isDuplicate = parent == child || parent.equals(child);
        if (parent.isSealed() && !isDuplicate) {
            throw new IllegalArgumentException(String.format("Fields %s and %s have conflicting definitions of option %s - parent field %s declares itself as sealed and cannot be overridden", parentField, childField, names, parentField));
        }
        if (!child.isOverride() && !isDuplicate) {
            throw new IllegalArgumentException(String.format("Fields %s and %s have conflicting definitions of option %s - if you wanted to override this option you must explicitly specify override = true in your child field annotation", parentField, childField, names));
        }
        OptionMetadata merged = OptionMetadata.override(names, parent, child);
        optionIndex.put(names, merged);
    }

    public static void loadCommandsIntoGroupsByAnnotation(List<CommandMetadata> allCommands, List<CommandGroupMetadata> commandGroups, List<CommandMetadata> defaultCommandGroup, Map<String, HelpSection> baseHelpSections) {
        ArrayList<CommandMetadata> newCommands = new ArrayList<CommandMetadata>();
        MetadataLoader.createGroupsFromAnnotations(allCommands, newCommands, commandGroups, defaultCommandGroup, baseHelpSections);
        for (CommandMetadata command : allCommands) {
            boolean addedToGroup = false;
            for (String groupName : command.getGroupNames()) {
                CommandGroupMetadata group = (CommandGroupMetadata)CollectionUtils.find(commandGroups, (Predicate)new GroupFinder(groupName));
                if (group != null) {
                    group.addCommand(command);
                    addedToGroup = true;
                    continue;
                }
                if (StringUtils.containsWhitespace((CharSequence)groupName)) {
                    String[] groups = StringUtils.split((String)groupName);
                    CommandGroupMetadata subGroup = null;
                    for (int i = 0; i < groups.length; ++i) {
                        if (i == 0) {
                            subGroup = (CommandGroupMetadata)CollectionUtils.find(commandGroups, (Predicate)new GroupFinder(groups[i]));
                            if (subGroup != null) continue;
                            subGroup = new CommandGroupMetadata(groups[i], "", false, Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList());
                            commandGroups.add(subGroup);
                            continue;
                        }
                        CommandGroupMetadata nextSubGroup = (CommandGroupMetadata)CollectionUtils.find(subGroup.getSubGroups(), (Predicate)new GroupFinder(groups[i]));
                        if (nextSubGroup == null) {
                            nextSubGroup = new CommandGroupMetadata(groups[i], "", false, Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList());
                        }
                        subGroup.addSubGroup(nextSubGroup);
                        subGroup = nextSubGroup;
                    }
                    if (subGroup == null) {
                        throw new IllegalStateException("Failed to resolve sub-group path");
                    }
                    subGroup.addCommand(command);
                    addedToGroup = true;
                    continue;
                }
                CommandGroupMetadata newGroup = MetadataLoader.loadCommandGroup(groupName, "", false, Collections.emptyList(), null, Collections.singletonList(command));
                commandGroups.add(newGroup);
                addedToGroup = true;
            }
            if (!addedToGroup || !defaultCommandGroup.contains(command)) continue;
            defaultCommandGroup.remove(command);
        }
        allCommands.addAll(newCommands);
    }

    private static void createGroupsFromAnnotations(List<CommandMetadata> allCommands, List<CommandMetadata> newCommands, List<CommandGroupMetadata> commandGroups, List<CommandMetadata> defaultCommandGroup, Map<String, HelpSection> baseHelpSections) {
        TreeMap<String, CommandGroupMetadata> subGroups = new TreeMap<String, CommandGroupMetadata>(new StringHierarchyComparator());
        for (CommandMetadata command : allCommands) {
            boolean addedToGroup = false;
            for (Group groupAnno : command.getGroups()) {
                Class<?> defaultCommandClass = null;
                CommandMetadata defaultCommand = null;
                if (!groupAnno.defaultCommand().equals(Group.NO_DEFAULT.class) && null == (defaultCommand = (CommandMetadata)CollectionUtils.find(allCommands, (Predicate)new CommandTypeFinder(defaultCommandClass = groupAnno.defaultCommand())))) {
                    defaultCommand = MetadataLoader.loadCommand(defaultCommandClass, baseHelpSections);
                    newCommands.add(defaultCommand);
                }
                ArrayList<CommandMetadata> groupCommands = new ArrayList<CommandMetadata>(groupAnno.commands().length);
                CommandMetadata groupCommand = null;
                for (Class<?> commandClass : groupAnno.commands()) {
                    groupCommand = (CommandMetadata)CollectionUtils.find(allCommands, (Predicate)new CommandTypeFinder(commandClass));
                    if (null != groupCommand) continue;
                    groupCommand = MetadataLoader.loadCommand(commandClass, baseHelpSections);
                    newCommands.add(groupCommand);
                    groupCommands.add(groupCommand);
                }
                CommandGroupMetadata groupMetadata = (CommandGroupMetadata)CollectionUtils.find(commandGroups, (Predicate)new GroupFinder(groupAnno.name()));
                if (groupMetadata == null) {
                    String subGroupPath = null;
                    if (StringUtils.containsWhitespace((CharSequence)groupAnno.name())) {
                        subGroupPath = StringUtils.join((Object[])StringUtils.split((String)groupAnno.name()), (String)" ");
                        groupMetadata = (CommandGroupMetadata)subGroups.get(subGroupPath);
                    }
                    if (groupMetadata == null) {
                        groupMetadata = MetadataLoader.loadCommandGroup(groupAnno.name(), groupAnno.description(), groupAnno.hidden(), Collections.emptyList(), defaultCommand, groupCommands);
                        if (!StringUtils.containsWhitespace((CharSequence)groupAnno.name())) {
                            commandGroups.add(groupMetadata);
                        } else {
                            subGroups.put(subGroupPath, groupMetadata);
                        }
                    }
                }
                groupMetadata.addCommand(command);
                addedToGroup = true;
            }
            if (!addedToGroup || !defaultCommandGroup.contains(command)) continue;
            defaultCommandGroup.remove(command);
        }
        MetadataLoader.buildGroupsHierarchy(commandGroups, subGroups);
    }

    protected static void buildGroupsHierarchy(List<CommandGroupMetadata> commandGroups, Map<String, CommandGroupMetadata> subGroups) {
        for (String subGroupPath : subGroups.keySet()) {
            CommandGroupMetadata subGroup = subGroups.get(subGroupPath);
            String[] groups = StringUtils.split((String)subGroupPath);
            CommandGroupMetadata parentGroup = null;
            for (int i = 0; i < groups.length - 1; ++i) {
                if (i == 0) {
                    parentGroup = (CommandGroupMetadata)CollectionUtils.find(commandGroups, (Predicate)new GroupFinder(groups[i]));
                    if (parentGroup != null) continue;
                    parentGroup = new CommandGroupMetadata(groups[i], "", false, Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList());
                    commandGroups.add(parentGroup);
                    continue;
                }
                CommandGroupMetadata nextParent = (CommandGroupMetadata)CollectionUtils.find(parentGroup.getSubGroups(), (Predicate)new GroupFinder(groups[i]));
                if (nextParent == null) {
                    nextParent = new CommandGroupMetadata(groups[i], "", false, Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList());
                }
                parentGroup.addSubGroup(nextParent);
                nextParent.setParent(parentGroup);
                parentGroup = nextParent;
            }
            if (parentGroup == null) {
                throw new IllegalStateException("Failed to resolve sub-group path");
            }
            parentGroup.addSubGroup(subGroup);
            subGroup.setParent(parentGroup);
        }
    }

    private static class InjectionMetadata {
        private List<OptionMetadata> globalOptions = new ArrayList<OptionMetadata>();
        private List<OptionMetadata> groupOptions = new ArrayList<OptionMetadata>();
        private List<OptionMetadata> commandOptions = new ArrayList<OptionMetadata>();
        private OptionMetadata defaultOption = null;
        private List<ArgumentsMetadata> arguments = new ArrayList<ArgumentsMetadata>();
        private List<Accessor> metadataInjections = new ArrayList<Accessor>();

        private InjectionMetadata() {
        }

        private void compact() {
            this.globalOptions = MetadataLoader.overrideOptionSet(this.globalOptions);
            this.groupOptions = MetadataLoader.overrideOptionSet(this.groupOptions);
            this.commandOptions = MetadataLoader.overrideOptionSet(this.commandOptions);
            if (this.defaultOption != null) {
                for (OptionMetadata option : this.commandOptions) {
                    boolean found = false;
                    for (String opt : this.defaultOption.getOptions()) {
                        if (!option.getOptions().contains(opt)) continue;
                        this.defaultOption = option;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
            }
            if (this.arguments.size() > 1) {
                this.arguments = ListUtils.unmodifiableList(Collections.singletonList(new ArgumentsMetadata(this.arguments)));
            }
        }
    }
}

