/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.factories;

import com.github.rvesse.airline.annotations.restrictions.EndsWith;
import com.github.rvesse.airline.annotations.restrictions.ExactLength;
import com.github.rvesse.airline.annotations.restrictions.MaxLength;
import com.github.rvesse.airline.annotations.restrictions.MinLength;
import com.github.rvesse.airline.annotations.restrictions.NotBlank;
import com.github.rvesse.airline.annotations.restrictions.NotEmpty;
import com.github.rvesse.airline.annotations.restrictions.Pattern;
import com.github.rvesse.airline.annotations.restrictions.StartsWith;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.EndsWithRestriction;
import com.github.rvesse.airline.restrictions.common.LengthRestriction;
import com.github.rvesse.airline.restrictions.common.NotBlankRestriction;
import com.github.rvesse.airline.restrictions.common.NotEmptyRestriction;
import com.github.rvesse.airline.restrictions.common.PatternRestriction;
import com.github.rvesse.airline.restrictions.common.StartsWithRestriction;
import com.github.rvesse.airline.restrictions.factories.ArgumentsRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.OptionRestrictionFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class StringRestrictionFactory
implements ArgumentsRestrictionFactory,
OptionRestrictionFactory {
    @Override
    public OptionRestriction createOptionRestriction(Annotation annotation) {
        return this.createCommon(annotation);
    }

    @Override
    public ArgumentsRestriction createArgumentsRestriction(Annotation annotation) {
        return this.createCommon(annotation);
    }

    protected AbstractCommonRestriction createCommon(Annotation annotation) {
        if (annotation instanceof Pattern) {
            Pattern pattern = (Pattern)annotation;
            return new PatternRestriction(pattern.pattern(), pattern.flags(), pattern.description());
        }
        if (annotation instanceof MaxLength) {
            MaxLength ml = (MaxLength)annotation;
            return new LengthRestriction(ml.length(), true);
        }
        if (annotation instanceof MinLength) {
            MinLength ml = (MinLength)annotation;
            return new LengthRestriction(ml.length(), false);
        }
        if (annotation instanceof ExactLength) {
            ExactLength el = (ExactLength)annotation;
            return new LengthRestriction(el.length(), el.length());
        }
        if (annotation instanceof NotBlank) {
            return new NotBlankRestriction();
        }
        if (annotation instanceof NotEmpty) {
            return new NotEmptyRestriction();
        }
        if (annotation instanceof EndsWith) {
            EndsWith ew = (EndsWith)annotation;
            return new EndsWithRestriction(ew.ignoreCase(), Locale.forLanguageTag(ew.locale()), ew.suffixes());
        }
        if (annotation instanceof StartsWith) {
            StartsWith sw = (StartsWith)annotation;
            return new StartsWithRestriction(sw.ignoreCase(), Locale.forLanguageTag(sw.locale()), sw.prefixes());
        }
        return null;
    }

    protected List<Class<? extends Annotation>> supportedAnnotations() {
        ArrayList<Class<? extends Annotation>> supported = new ArrayList<Class<? extends Annotation>>();
        supported.add(Pattern.class);
        supported.add(MaxLength.class);
        supported.add(MinLength.class);
        supported.add(ExactLength.class);
        supported.add(NotBlank.class);
        supported.add(NotEmpty.class);
        supported.add(EndsWith.class);
        supported.add(StartsWith.class);
        return supported;
    }

    @Override
    public List<Class<? extends Annotation>> supportedOptionAnnotations() {
        return this.supportedAnnotations();
    }

    @Override
    public List<Class<? extends Annotation>> supportedArgumentsAnnotations() {
        return this.supportedAnnotations();
    }
}

