/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.factories;

import com.github.rvesse.airline.annotations.restrictions.ranges.ByteRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.DoubleRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.FloatRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.IntegerRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.LengthRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.LexicalRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.LongRange;
import com.github.rvesse.airline.annotations.restrictions.ranges.Negative;
import com.github.rvesse.airline.annotations.restrictions.ranges.Positive;
import com.github.rvesse.airline.annotations.restrictions.ranges.ShortRange;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.LengthRestriction;
import com.github.rvesse.airline.restrictions.common.PositiveNegativeRestriction;
import com.github.rvesse.airline.restrictions.common.RangeRestriction;
import com.github.rvesse.airline.restrictions.factories.ArgumentsRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.OptionRestrictionFactory;
import com.github.rvesse.airline.utils.comparators.ByteComparator;
import com.github.rvesse.airline.utils.comparators.DoubleComparator;
import com.github.rvesse.airline.utils.comparators.FloatComparator;
import com.github.rvesse.airline.utils.comparators.IntegerComparator;
import com.github.rvesse.airline.utils.comparators.LexicalComparator;
import com.github.rvesse.airline.utils.comparators.LongComparator;
import com.github.rvesse.airline.utils.comparators.ShortComparator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class RangeRestrictionFactory
implements OptionRestrictionFactory,
ArgumentsRestrictionFactory {
    private static final Comparator<Object> LONG_COMPARATOR = new LongComparator();
    private static final Comparator<Object> INTEGER_COMPARATOR = new IntegerComparator();
    private static final Comparator<Object> SHORT_COMPARATOR = new ShortComparator();
    private static final Comparator<Object> BYTE_COMPARATOR = new ByteComparator();
    private static final Comparator<Object> DOUBLE_COMPARATOR = new DoubleComparator();
    private static final Comparator<Object> FLOAT_COMPARATOR = new FloatComparator();

    @Override
    public final OptionRestriction createOptionRestriction(Annotation annotation) {
        return this.createCommon(annotation);
    }

    @Override
    public final ArgumentsRestriction createArgumentsRestriction(Annotation annotation) {
        return this.createCommon(annotation);
    }

    protected final AbstractCommonRestriction createCommon(Annotation annotation) {
        if (annotation instanceof LongRange) {
            return this.createLongRange(annotation);
        }
        if (annotation instanceof IntegerRange) {
            return this.createIntegerRange(annotation);
        }
        if (annotation instanceof ShortRange) {
            return this.createShortRange(annotation);
        }
        if (annotation instanceof ByteRange) {
            return this.createByteRange(annotation);
        }
        if (annotation instanceof DoubleRange) {
            return this.createDoubleRange(annotation);
        }
        if (annotation instanceof FloatRange) {
            return this.createFloatRange(annotation);
        }
        if (annotation instanceof LexicalRange) {
            return this.createLexicalRange(annotation);
        }
        if (annotation instanceof LengthRange) {
            return this.createLengthRange(annotation);
        }
        if (annotation instanceof Positive) {
            return new PositiveNegativeRestriction(true, ((Positive)annotation).includesZero());
        }
        if (annotation instanceof Negative) {
            return new PositiveNegativeRestriction(false, ((Negative)annotation).includesZero());
        }
        return this.createUnknownRange(annotation);
    }

    protected AbstractCommonRestriction createUnknownRange(Annotation annotation) {
        return null;
    }

    protected AbstractCommonRestriction createLengthRange(Annotation annotation) {
        LengthRange lRange = (LengthRange)annotation;
        return new LengthRestriction(lRange.min(), lRange.max());
    }

    protected RangeRestriction createLexicalRange(Annotation annotation) {
        LexicalRange lRange = (LexicalRange)annotation;
        return new RangeRestriction(StringUtils.isEmpty((CharSequence)lRange.min()) ? null : lRange.min(), lRange.minInclusive(), StringUtils.isEmpty((CharSequence)lRange.max()) ? null : lRange.max(), lRange.maxInclusive(), new LexicalComparator(Locale.forLanguageTag(lRange.locale())));
    }

    protected RangeRestriction createFloatRange(Annotation annotation) {
        FloatRange sRange = (FloatRange)annotation;
        return new RangeRestriction(sRange.min() != Float.MIN_VALUE || !sRange.minInclusive() ? Float.valueOf(sRange.min()) : null, sRange.minInclusive(), sRange.max() != Float.MAX_VALUE || !sRange.maxInclusive() ? Float.valueOf(sRange.max()) : null, sRange.maxInclusive(), FLOAT_COMPARATOR);
    }

    protected RangeRestriction createDoubleRange(Annotation annotation) {
        DoubleRange sRange = (DoubleRange)annotation;
        return new RangeRestriction(sRange.min() != Double.MIN_VALUE || !sRange.minInclusive() ? Double.valueOf(sRange.min()) : null, sRange.minInclusive(), sRange.max() != Double.MAX_VALUE || !sRange.maxInclusive() ? Double.valueOf(sRange.max()) : null, sRange.maxInclusive(), DOUBLE_COMPARATOR);
    }

    protected RangeRestriction createByteRange(Annotation annotation) {
        ByteRange sRange = (ByteRange)annotation;
        return new RangeRestriction(sRange.min(), sRange.minInclusive(), sRange.max(), sRange.maxInclusive(), BYTE_COMPARATOR);
    }

    protected RangeRestriction createShortRange(Annotation annotation) {
        ShortRange sRange = (ShortRange)annotation;
        return new RangeRestriction(sRange.min() != Short.MIN_VALUE || !sRange.minInclusive() ? Short.valueOf(sRange.min()) : null, sRange.minInclusive(), sRange.max() != Short.MAX_VALUE || !sRange.maxInclusive() ? Short.valueOf(sRange.max()) : null, sRange.maxInclusive(), SHORT_COMPARATOR);
    }

    protected RangeRestriction createIntegerRange(Annotation annotation) {
        IntegerRange iRange = (IntegerRange)annotation;
        return new RangeRestriction(iRange.min() != Integer.MIN_VALUE || !iRange.minInclusive() ? Integer.valueOf(iRange.min()) : null, iRange.minInclusive(), iRange.max() != Integer.MAX_VALUE || !iRange.maxInclusive() ? Integer.valueOf(iRange.max()) : null, iRange.maxInclusive(), INTEGER_COMPARATOR);
    }

    protected RangeRestriction createLongRange(Annotation annotation) {
        LongRange iRange = (LongRange)annotation;
        return new RangeRestriction(iRange.min() != Long.MIN_VALUE || !iRange.minInclusive() ? Long.valueOf(iRange.min()) : null, iRange.minInclusive(), iRange.max() != Long.MAX_VALUE || !iRange.maxInclusive() ? Long.valueOf(iRange.max()) : null, iRange.maxInclusive(), LONG_COMPARATOR);
    }

    protected List<Class<? extends Annotation>> supportedAnnotations() {
        ArrayList<Class<? extends Annotation>> supported = new ArrayList<Class<? extends Annotation>>();
        supported.add(LongRange.class);
        supported.add(IntegerRange.class);
        supported.add(ShortRange.class);
        supported.add(ByteRange.class);
        supported.add(DoubleRange.class);
        supported.add(FloatRange.class);
        supported.add(LexicalRange.class);
        supported.add(LengthRange.class);
        supported.add(Negative.class);
        supported.add(Positive.class);
        return supported;
    }

    @Override
    public List<Class<? extends Annotation>> supportedArgumentsAnnotations() {
        return this.supportedAnnotations();
    }

    @Override
    public List<Class<? extends Annotation>> supportedOptionAnnotations() {
        return this.supportedAnnotations();
    }
}

