/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.DefaultOption;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.builder.CliBuilder;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultCommand {
    protected <T> Cli<T> createSimpleCli(Class<T> cls) {
        Cli cli = new CliBuilder("test").withDefaultCommand(cls).build();
        return cli;
    }

    protected Cli<Args> createSimpleCli() {
        return this.createSimpleCli(Args.class);
    }

    @Test
    public void default_command_01() {
        Cli<Args> cli = this.createSimpleCli();
        Args cmd = (Args)cli.parse(new String[0]);
        Assert.assertNotNull((Object)cmd);
        Assert.assertTrue((boolean)cmd.args.isEmpty());
    }

    @Test
    public void default_command_02() {
        Cli<Args> cli = this.createSimpleCli();
        Args cmd = (Args)cli.parse(new String[]{"args"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertTrue((boolean)cmd.args.isEmpty());
    }

    @Test
    public void default_command_03() {
        Cli<Args> cli = this.createSimpleCli();
        Args cmd = (Args)cli.parse(new String[]{"foo"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertFalse((boolean)cmd.args.isEmpty());
        Assert.assertEquals((int)cmd.args.size(), (int)1);
        Assert.assertEquals((String)cmd.args.get(0), (String)"foo");
    }

    @Test
    public void default_command_04() {
        Cli cli = ((CliBuilder)new CliBuilder("test").withGroup("group").withDefaultCommand(Args.class).parent()).build();
        Args cmd = (Args)cli.parse(new String[]{"group", "foo"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertFalse((boolean)cmd.args.isEmpty());
        Assert.assertEquals((int)cmd.args.size(), (int)1);
        Assert.assertEquals((String)cmd.args.get(0), (String)"foo");
    }

    @Test
    public void default_command_05() {
        Cli cli = ((CliBuilder)new CliBuilder("test").withGroup("group").withDefaultCommand(Args.class).withCommand(Args.class).parent()).build();
        Args cmd = (Args)cli.parse(new String[]{"group", "foo"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertFalse((boolean)cmd.args.isEmpty());
        Assert.assertEquals((int)cmd.args.size(), (int)1);
        Assert.assertEquals((String)cmd.args.get(0), (String)"foo");
    }

    @Test
    public void default_command_abbreviation_01() {
        CliBuilder builder = new CliBuilder("test").withDefaultCommand(Args.class);
        builder.withParser().withCommandAbbreviation();
        Cli cli = builder.build();
        Args cmd = (Args)cli.parse(new String[]{"foo"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertFalse((boolean)cmd.args.isEmpty());
        Assert.assertEquals((int)cmd.args.size(), (int)1);
        Assert.assertEquals((String)cmd.args.get(0), (String)"foo");
    }

    @Test
    public void default_command_abbreviation_02() {
        CliBuilder builder = new CliBuilder("test").withDefaultCommand(Args.class).withCommand(Args.class);
        builder.withParser().withCommandAbbreviation();
        Cli cli = builder.build();
        Args cmd = (Args)cli.parse(new String[]{"foo"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertFalse((boolean)cmd.args.isEmpty());
        Assert.assertEquals((int)cmd.args.size(), (int)1);
        Assert.assertEquals((String)cmd.args.get(0), (String)"foo");
    }

    @Test
    public void default_command_abbreviation_03() {
        CliBuilder builder = (CliBuilder)new CliBuilder("test").withGroup("group").withDefaultCommand(Args.class).withCommand(Args.class).parent();
        builder.withParser().withCommandAbbreviation();
        Cli cli = builder.build();
        Args cmd = (Args)cli.parse(new String[]{"group", "foo"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertFalse((boolean)cmd.args.isEmpty());
        Assert.assertEquals((int)cmd.args.size(), (int)1);
        Assert.assertEquals((String)cmd.args.get(0), (String)"foo");
    }

    @Test
    public void default_command_abbreviation_04() {
        CliBuilder builder = (CliBuilder)new CliBuilder("test").withGroup("group").withDefaultCommand(Args.class).withCommand(Args.class).parent();
        builder.withParser().withCommandAbbreviation();
        Cli cli = builder.build();
        Args cmd = (Args)cli.parse(new String[]{"group", "ar", "foo"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertFalse((boolean)cmd.args.isEmpty());
        Assert.assertEquals((int)cmd.args.size(), (int)1);
        Assert.assertEquals((String)cmd.args.get(0), (String)"foo");
    }

    @Test
    public void default_command_default_option_01() {
        Cli<ArgsWithDefaultOption> cli = this.createSimpleCli(ArgsWithDefaultOption.class);
        ArgsWithDefaultOption cmd = (ArgsWithDefaultOption)cli.parse(new String[0]);
        Assert.assertNotNull((Object)cmd);
        Assert.assertTrue((boolean)cmd.args.isEmpty());
    }

    @Test
    public void default_command_default_option_02() {
        Cli<ArgsWithDefaultOption> cli = this.createSimpleCli(ArgsWithDefaultOption.class);
        ArgsWithDefaultOption cmd = (ArgsWithDefaultOption)cli.parse(new String[]{"args"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertTrue((boolean)cmd.args.isEmpty());
    }

    @Test
    public void default_command_default_option_03() {
        Cli<ArgsWithDefaultOption> cli = this.createSimpleCli(ArgsWithDefaultOption.class);
        ArgsWithDefaultOption cmd = (ArgsWithDefaultOption)cli.parse(new String[]{"foo"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertFalse((boolean)cmd.args.isEmpty());
        Assert.assertEquals((int)cmd.args.size(), (int)1);
        Assert.assertEquals((String)cmd.args.get(0), (String)"foo");
    }

    @Test
    public void default_command_default_option_04() {
        Cli cli = ((CliBuilder)new CliBuilder("test").withGroup("group").withDefaultCommand(ArgsWithDefaultOption.class).parent()).build();
        ArgsWithDefaultOption cmd = (ArgsWithDefaultOption)cli.parse(new String[]{"group", "foo"});
        Assert.assertNotNull((Object)cmd);
        Assert.assertFalse((boolean)cmd.args.isEmpty());
        Assert.assertEquals((int)cmd.args.size(), (int)1);
        Assert.assertEquals((String)cmd.args.get(0), (String)"foo");
    }

    @Command(name="args")
    public static final class ArgsWithDefaultOption {
        @Option(name={"-a"})
        @DefaultOption
        List<String> args = new ArrayList<String>();
    }

    @Command(name="args")
    public static final class Args {
        @Arguments
        List<String> args = new ArrayList<String>();
    }
}

