/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.GitWithCliAnnotation;
import com.github.rvesse.airline.GitWithCliAnnotation2;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.model.ParserMetadata;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGitByAnnotation {
    @Test
    public void test() {
        this.git("add", "-p", "file");
        this.git("remote", "add", "origin", "git@github.com:airlift/airline.git");
        this.git("-v", "remote", "show", "origin");
        this.git("remote");
        this.git("remote", "origin");
        this.git("remote", "-n", "origin");
        this.git("-v", "remote", "origin");
        this.git(new String[0]);
        this.git("help");
        this.git("help", "git");
        this.git("help", "add");
        this.git("help", "remote");
        this.git("help", "remote", "show");
    }

    @Test
    public void testParserConfigOverride() {
        ParserMetadata parserConfig = new ParserBuilder().withCommandAbbreviation().build();
        this.git((ParserMetadata<Runnable>)parserConfig, "rem");
        this.git((ParserMetadata<Runnable>)parserConfig, "rem show");
        this.git((ParserMetadata<Runnable>)parserConfig, "rem sh");
        this.git((ParserMetadata<Runnable>)parserConfig, "remote sh");
    }

    @Test
    public void testParserConfigOverride2() {
        ParserMetadata parserConfig = new ParserBuilder().withCommandAbbreviation().build();
        this.gitOverridden(null, "foo");
        this.gitOverridden((ParserMetadata<Runnable>)parserConfig, "rem");
        this.gitOverridden((ParserMetadata<Runnable>)parserConfig, "rem", "show");
        this.gitOverridden((ParserMetadata<Runnable>)parserConfig, "rem", "sh");
        this.gitOverridden((ParserMetadata<Runnable>)parserConfig, "remote", "sh");
        Cli gitParser = new Cli(GitWithCliAnnotation2.class, parserConfig);
        Runnable cmd = (Runnable)gitParser.parse(new String[]{"foo"});
        Assert.assertEquals(cmd.getClass(), Help.class);
    }

    private void git(String ... args) {
        System.out.println("$ git " + StringUtils.join((Object[])args, (char)' '));
        GitWithCliAnnotation.run(args);
        System.out.println();
    }

    private void git(ParserMetadata<Runnable> parserConfig, String ... args) {
        System.out.println("$ git " + StringUtils.join((Object[])args, (char)' '));
        Cli gitParser = new Cli(GitWithCliAnnotation.class, parserConfig);
        ((Runnable)gitParser.parse(args)).run();
        System.out.println();
    }

    private void gitOverridden(ParserMetadata<Runnable> parserConfig, String ... args) {
        System.out.println("$ git " + StringUtils.join((Object[])args, (char)' '));
        Cli gitParser = new Cli(GitWithCliAnnotation2.class, parserConfig);
        ((Runnable)gitParser.parse(args)).run();
        System.out.println();
    }
}

